/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.AbstractFilenameGenerator;
import adams.core.io.AbstractFilenameGeneratorWithDirectory;
import adams.core.io.AbstractFilenameGeneratorWithExtension;
import adams.core.io.DefaultFilenameGenerator;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.io.output.AbstractReportWriter;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public abstract class AbstractReportFileWriter<T extends Report>
extends AbstractTransformer {
    private static final long serialVersionUID = -5209437097716008045L;
    protected AbstractReportWriter<T> m_Writer;
    protected PlaceholderDirectory m_OutputDir;
    protected AbstractFilenameGenerator m_Generator;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", this.getDefaultWriter());
        this.m_OptionManager.add("dir", "outputDir", new PlaceholderDirectory("."));
        this.m_OptionManager.add("generator", "filenameGenerator", this.getDefaultFilenameGenerator());
    }

    protected abstract AbstractReportWriter<T> getDefaultWriter();

    public void setWriter(AbstractReportWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractReportWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for saving the reports.";
    }

    public void setOutputDir(PlaceholderDirectory value) {
        this.m_OutputDir = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDir() {
        return this.m_OutputDir;
    }

    public String outputDirTipText() {
        return "The output directory for the reports.";
    }

    protected AbstractFilenameGenerator getDefaultFilenameGenerator() {
        return new DefaultFilenameGenerator();
    }

    public void setFilenameGenerator(AbstractFilenameGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractFilenameGenerator getFilenameGenerator() {
        return this.m_Generator;
    }

    public String filenameGeneratorTipText() {
        return "The filename generator to use for creating the filename for the report.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "writer", this.m_Writer);
    }

    @Override
    public abstract Class[] accepts();

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected T extractReport(Token token) {
        if (token.getPayload() instanceof ReportHandler) {
            return ((ReportHandler)this.m_InputToken.getPayload()).getReport();
        }
        if (this.m_InputToken.getPayload() instanceof Report) {
            return (T)((Report)this.m_InputToken.getPayload());
        }
        return null;
    }

    @Override
    protected String doExecute() {
        String result = null;
        T report = this.extractReport(this.m_InputToken);
        if (report == null) {
            result = "No report available: " + this.m_InputToken.getPayload();
        } else {
            String filename;
            if (this.m_Generator instanceof AbstractFilenameGeneratorWithDirectory) {
                ((AbstractFilenameGeneratorWithDirectory)this.m_Generator).setDirectory(this.m_OutputDir);
            }
            if (this.m_Generator instanceof AbstractFilenameGeneratorWithExtension) {
                ((AbstractFilenameGeneratorWithExtension)this.m_Generator).setExtension("." + this.m_Writer.getFormatExtensions()[0]);
            }
            if ((filename = this.m_Generator.generate(report)) == null) {
                result = "Failed to generate filename from:\n" + report;
            }
            if (result == null) {
                File file = new File(filename);
                this.m_Writer.setOutput(new PlaceholderFile(file));
                try {
                    boolean success = this.m_Writer.write(report);
                    if (!success) {
                        result = "Failed to write data to '" + file + "'!";
                    }
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("SampleData #" + ((Report)report).getDatabaseID() + " written to " + file + ": " + success);
                    }
                    this.m_Writer.cleanUp();
                    if (success) {
                        this.m_OutputToken = new Token(file.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    result = this.handleException("Error writing to '" + file + "': ", e);
                }
            }
        }
        return result;
    }
}

