/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.NotesHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class AddNote
extends AbstractTransformer {
    private static final long serialVersionUID = 4013915680601748582L;
    protected String m_NoteGroup;
    protected String m_NoteType;
    protected String m_NoteValue;

    @Override
    public String globalInfo() {
        return "Adds a note to the notes handler passing through.\nPre-defined note types:\n- ERROR: \n- WARNING: \n- PROCESS INFORMATION";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("note-group", "noteGroup", "");
        this.m_OptionManager.add("note-type", "noteType", "");
        this.m_OptionManager.add("note-value", "noteValue", "");
    }

    public void setNoteGroup(String value) {
        this.m_NoteGroup = value;
        this.reset();
    }

    public String getNoteGroup() {
        return this.m_NoteGroup;
    }

    public String noteGroupTipText() {
        return "The group to file the note under, eg a classname.";
    }

    public void setNoteType(String value) {
        this.m_NoteType = value;
        this.reset();
    }

    public String getNoteType() {
        return this.m_NoteType;
    }

    public String noteTypeTipText() {
        return "The type of note to add (prefixes the note value); predefined: ERROR: , WARNING: , PROCESS INFORMATION";
    }

    public void setNoteValue(String value) {
        this.m_NoteValue = value;
        this.reset();
    }

    public String getNoteValue() {
        return this.m_NoteValue;
    }

    public String noteValueTipText() {
        return "The value of the note to add.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "noteGroup", this.m_NoteGroup.isEmpty() ? "-no group-" : this.m_NoteGroup, "group: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "noteType", this.m_NoteType.isEmpty() ? "-no type-" : this.m_NoteType, ", type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "noteValue", this.m_NoteValue.isEmpty() ? "-no value-" : this.m_NoteValue, ", value: ");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{NotesHandler.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{NotesHandler.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            NotesHandler handler = (NotesHandler)this.m_InputToken.getPayload();
            handler.getNotes().addNote(this.m_NoteGroup, this.m_NoteType + this.m_NoteValue);
            this.m_OutputToken = new Token(handler);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to add note (" + this.m_NoteGroup + "/" + this.m_NoteType + "/" + this.m_NoteValue + ") to: " + this.m_InputToken.getPayload(), e);
        }
        return result;
    }
}

