/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateTime;
import adams.core.DateTimeType;
import adams.core.QuickInfoHelper;
import adams.core.Time;
import adams.core.base.BaseDate;
import adams.core.base.BaseDateTime;
import adams.core.base.BaseTime;
import adams.core.option.OptionHandler;
import adams.data.conversion.ConvertDateTimeType;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Array;
import java.util.Date;

public class DateTimeTypeDifference
extends AbstractTransformer {
    private static final long serialVersionUID = 1393364512048214265L;
    protected DateTimeType m_InputDateTimeType;
    protected DateTimeType m_OutputDateTimeType;
    protected ConvertDateTimeType m_ConversionInput;
    protected ConvertDateTimeType m_ConversionOutput;

    @Override
    public String globalInfo() {
        return "Computes the difference between the two date/time types of the incoming array (of length 2) by subtracting the second element from the first one.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("input-datetime-type", "inputDateTimeType", (Object)DateTimeType.DATE);
        this.m_OptionManager.add("output-datetime-type", "outputDateTimeType", (Object)DateTimeType.MSECS);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_ConversionInput = null;
        this.m_ConversionOutput = null;
    }

    public void setInputDateTimeType(DateTimeType value) {
        this.m_InputDateTimeType = value;
        this.reset();
    }

    public DateTimeType getInputDateTimeType() {
        return this.m_InputDateTimeType;
    }

    public String inputDateTimeTypeTipText() {
        return "The date/time type of the input data.";
    }

    public void setOutputDateTimeType(DateTimeType value) {
        this.m_OutputDateTimeType = value;
        this.reset();
    }

    public DateTimeType getOutputDateTimeType() {
        return this.m_OutputDateTimeType;
    }

    public String outputDateTimeTypeTipText() {
        return "The date/time type of the output data.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "inputDateType", (Object)this.m_InputDateTimeType);
        result = result + "[] -> ";
        result = result + QuickInfoHelper.toString((OptionHandler)this, "outputDateType", (Object)this.m_OutputDateTimeType);
        return result;
    }

    @Override
    public Class[] accepts() {
        switch (this.m_InputDateTimeType) {
            case MSECS: {
                return new Class[]{Double[].class};
            }
            case SECONDS: {
                return new Class[]{Double[].class};
            }
            case DATE: {
                return new Class[]{Date[].class};
            }
            case DATETIME: {
                return new Class[]{DateTime[].class};
            }
            case TIME: {
                return new Class[]{Time[].class};
            }
            case BASEDATE: {
                return new Class[]{BaseDate[].class};
            }
            case BASEDATETIME: {
                return new Class[]{BaseDateTime[].class};
            }
            case BASETIME: {
                return new Class[]{BaseTime[].class};
            }
            case JULIANDATE: {
                return new Class[]{Double[].class};
            }
        }
        throw new IllegalStateException("Unhandled input data/time type: " + (Object)((Object)this.m_InputDateTimeType));
    }

    @Override
    public Class[] generates() {
        switch (this.m_OutputDateTimeType) {
            case MSECS: {
                return new Class[]{Double.class};
            }
            case SECONDS: {
                return new Class[]{Double.class};
            }
            case DATE: {
                return new Class[]{Date.class};
            }
            case DATETIME: {
                return new Class[]{DateTime.class};
            }
            case TIME: {
                return new Class[]{Time.class};
            }
            case BASEDATE: {
                return new Class[]{BaseDate.class};
            }
            case BASEDATETIME: {
                return new Class[]{BaseDateTime.class};
            }
            case BASETIME: {
                return new Class[]{BaseTime.class};
            }
            case JULIANDATE: {
                return new Class[]{Double.class};
            }
        }
        throw new IllegalStateException("Unhandled output data/time type: " + (Object)((Object)this.m_OutputDateTimeType));
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.m_ConversionInput == null) {
            this.m_ConversionInput = new ConvertDateTimeType();
            this.m_ConversionInput.setInputDateTimeType(this.m_InputDateTimeType);
            this.m_ConversionInput.setOutputDateTimeType(DateTimeType.MSECS);
        }
        double diff = Double.NaN;
        Object array = this.m_InputToken.getPayload();
        if (Array.getLength(array) != 2) {
            result = "Input array must have length 2, received: " + Array.getLength(array);
        }
        if (result == null) {
            double[] in = new double[2];
            for (int i = 0; i < 2; ++i) {
                this.m_ConversionInput.setInput(Array.get(array, i));
                result = this.m_ConversionInput.convert();
                if (result != null) break;
                in[i] = (Double)this.m_ConversionInput.getOutput();
            }
            if (result == null) {
                diff = in[0] - in[1];
            }
            this.m_ConversionInput.cleanUp();
        }
        if (result == null) {
            if (this.m_ConversionOutput == null) {
                this.m_ConversionOutput = new ConvertDateTimeType();
                this.m_ConversionOutput.setInputDateTimeType(DateTimeType.MSECS);
                this.m_ConversionOutput.setOutputDateTimeType(this.m_OutputDateTimeType);
            }
            this.m_ConversionOutput.setInput(diff);
            result = this.m_ConversionOutput.convert();
            if (result == null) {
                this.m_OutputToken = new Token(this.m_ConversionOutput.getOutput());
            }
            this.m_ConversionOutput.cleanUp();
        }
        return result;
    }
}

