/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class DeleteFile
extends AbstractTransformer {
    private static final long serialVersionUID = 4670761846363281951L;
    protected BaseRegExp m_RegExp;

    @Override
    public String globalInfo() {
        return "Deletes the file/directory received on its input port if it matches the provided regular expression.\nIn case of directories, deletion is performed recursively (if a directory matches, then the content gets deleted regardless whether it matches the regular expression or not).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "regExp", this.m_RegExp.isMatchAll() || this.m_RegExp.isEmpty() ? "all files" : this.m_RegExp.getValue());
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to match the filename against.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class, File.class};
    }

    @Override
    protected String doExecute() {
        String result;
        PlaceholderFile file = this.m_InputToken.getPayload() instanceof File ? new PlaceholderFile((File)this.m_InputToken.getPayload()) : new PlaceholderFile((String)this.m_InputToken.getPayload());
        String type = ((File)file).isDirectory() ? "directory" : "file";
        try {
            this.getLogger().info(type + " '" + file + "' exists: " + ((File)file).exists());
            if (((File)file).exists()) {
                this.getLogger().info(type + " '" + file + "' matches '" + this.m_RegExp + "': " + this.m_RegExp.isMatch(file.getName()));
                if (this.m_RegExp.isMatch(file.getName()) && !FileUtils.delete(file)) {
                    String string = "Failed to delete " + type + ": " + file;
                }
            }
            result = null;
        }
        catch (Exception e) {
            result = this.handleException("Problem deleting " + type + " '" + file + "': ", e);
        }
        this.m_OutputToken = new Token(this.m_InputToken.getPayload());
        return result;
    }
}

