/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.AppendName;
import adams.flow.transformer.BaseName;
import adams.flow.transformer.FileExtension;
import adams.flow.transformer.PrependDir;
import java.io.File;

public class DirName
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = 4670761846363281951L;

    @Override
    public String globalInfo() {
        return "Extracts the directory part of the file/directory passing through, i.e., any trailing name part gets stripped.";
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{AppendName.class, PrependDir.class, BaseName.class, FileExtension.class};
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        boolean array = this.m_InputToken.getPayload().getClass().isArray();
        boolean string = this.m_InputToken.getPayload() instanceof String || this.m_InputToken.getPayload() instanceof String[];
        PlaceholderFile[] files = FileUtils.toPlaceholderFileArray(this.m_InputToken.getPayload());
        String[] strings = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            if (string) {
                strings[i] = ((File)files[i]).getParent();
                continue;
            }
            files[i] = ((File)files[i]).getParentFile();
        }
        this.m_OutputToken = string ? (array ? new Token(strings) : new Token(strings[0])) : (array ? new Token(files) : new Token(files[0]));
        return result;
    }
}

