/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateTime;
import adams.core.PropertiesDataType;
import adams.core.QuickInfoHelper;
import adams.core.Time;
import adams.core.base.BasePassword;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.flow.transformer.AbstractArrayProvider;
import java.awt.Color;
import java.awt.Font;
import java.util.Date;
import java.util.Properties;
import java.util.Set;

public class GetPropertyValue
extends AbstractArrayProvider {
    private static final long serialVersionUID = -8757919765508522198L;
    protected BaseRegExp m_Key;
    protected PropertiesDataType m_DataType;
    protected boolean m_ForwardNull;

    @Override
    public String globalInfo() {
        return "Obtains the value(s) associated with the keys that match the specified regular expression from the Properties object passing through.\nNull values are only forwarded if requested.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key", "key", new BaseRegExp(".*"));
        this.m_OptionManager.add("data-type", "dataType", (Object)PropertiesDataType.PROPERTY);
        this.m_OptionManager.add("forward-null", "forwardNull", false);
    }

    @Override
    protected Class getItemClass() {
        switch (this.m_DataType) {
            case PROPERTY: 
            case PATH: {
                return String.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case LONG: {
                return Integer.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case COLOR: {
                return Color.class;
            }
            case FONT: {
                return Font.class;
            }
            case TIME: {
                return Time.class;
            }
            case DATE: {
                return Date.class;
            }
            case DATETIME: {
                return DateTime.class;
            }
            case PASSWORD: {
                return BasePassword.class;
            }
        }
        throw new IllegalStateException("Unhandled properties data type: " + (Object)((Object)this.m_DataType));
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to output the values as array or one-by-one.";
    }

    public void setKey(BaseRegExp value) {
        this.m_Key = value;
        this.reset();
    }

    public BaseRegExp getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The regular expression to match the keys against.";
    }

    public void setDataType(PropertiesDataType value) {
        this.m_DataType = value;
        this.reset();
    }

    public PropertiesDataType getDataType() {
        return this.m_DataType;
    }

    public String dataTypeTipText() {
        return "The type of the data that is output.";
    }

    public void setForwardNull(boolean value) {
        this.m_ForwardNull = value;
        this.reset();
    }

    public boolean getForwardNull() {
        return this.m_ForwardNull;
    }

    public String forwardNullTipText() {
        return "If enabled, null values are forward as well.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "key", this.m_Key, "key: ");
        result = result != null ? result + ", " : "";
        result = result + QuickInfoHelper.toString((OptionHandler)this, "dataType", (Object)this.m_DataType, "data-type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "forwardNull", this.m_ForwardNull, "forward null", ", ");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Properties.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        adams.core.Properties props = this.m_InputToken.getPayload() instanceof adams.core.Properties ? (adams.core.Properties)this.m_InputToken.getPayload() : new adams.core.Properties((Properties)this.m_InputToken.getPayload());
        Set<String> keys = props.keySetAll(this.m_Key);
        if (keys.size() == 0 && this.m_ForwardNull) {
            this.m_Queue.add(null);
        } else {
            for (String key : keys) {
                Object val;
                switch (this.m_DataType) {
                    case PROPERTY: {
                        val = props.getProperty(key);
                        break;
                    }
                    case PATH: {
                        val = props.getPath(key);
                        break;
                    }
                    case BOOLEAN: {
                        val = props.getBoolean(key);
                        break;
                    }
                    case INTEGER: {
                        val = props.getInteger(key);
                        break;
                    }
                    case LONG: {
                        val = props.getLong(key);
                        break;
                    }
                    case DOUBLE: {
                        val = props.getDouble(key);
                        break;
                    }
                    case COLOR: {
                        val = props.getColor(key);
                        break;
                    }
                    case FONT: {
                        val = props.getFont(key);
                        break;
                    }
                    case TIME: {
                        val = props.getTime(key);
                        break;
                    }
                    case DATE: {
                        val = props.getDate(key);
                        break;
                    }
                    case DATETIME: {
                        val = props.getDateTime(key);
                        break;
                    }
                    case PASSWORD: {
                        val = props.getPassword(key);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled properties data type: " + (Object)((Object)this.m_DataType));
                    }
                }
                if (val == null && !this.m_ForwardNull) continue;
                this.m_Queue.add(val);
            }
        }
        return result;
    }
}

