/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.HashSetInit;
import java.util.HashSet;

public class HashSetAdd
extends AbstractTransformer {
    private static final long serialVersionUID = 7602201480653131469L;
    protected StorageName m_StorageName;

    @Override
    public String globalInfo() {
        return "Adds a value to the specified hashset. \nThe input for the actor can be any object, the user has to ensure that the correct type is stored.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", new StorageName("hashset"));
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName, "storage: ");
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the hashset in the internal storage.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Object.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Object.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (!this.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "Hashset '" + this.m_StorageName + "' not available! Not initialized with " + HashSetInit.class.getName() + "?";
        } else {
            HashSet hashset = (HashSet)this.getStorageHandler().getStorage().get(this.m_StorageName);
            Object value = this.m_InputToken.getPayload();
            if (this.isLoggingEnabled()) {
                if (hashset.contains(value)) {
                    this.getLogger().info("Replacing: '" + value + "'");
                } else {
                    this.getLogger().info("Adding: '" + value + "'");
                }
            }
            hashset.add(value);
            this.m_OutputToken = this.m_InputToken;
        }
        return result;
    }
}

