/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Utils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Array;

public class PrimitiveArrayToObjectArray
extends AbstractTransformer {
    private static final long serialVersionUID = 3753370837923928436L;

    @Override
    public String globalInfo() {
        return "Turns a primitive array into an object one. Depending on the input type, either an Integer or Double array.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Integer[].class, Double[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            Object arrayIn = this.m_InputToken.getPayload();
            int len = Array.getLength(arrayIn);
            Number[] arrayOut = null;
            if (arrayIn instanceof byte[]) {
                arrayOut = new Integer[len];
                for (int i = 0; i < len; ++i) {
                    Array.set(arrayOut, i, new Integer(Array.getByte(arrayIn, i)));
                }
            } else if (arrayIn instanceof short[]) {
                arrayOut = new Integer[len];
                for (int i = 0; i < len; ++i) {
                    Array.set(arrayOut, i, new Integer(Array.getShort(arrayIn, i)));
                }
            } else if (arrayIn instanceof int[]) {
                arrayOut = new Integer[len];
                for (int i = 0; i < len; ++i) {
                    Array.set(arrayOut, i, new Integer(Array.getInt(arrayIn, i)));
                }
            } else if (arrayIn instanceof long[]) {
                arrayOut = new Integer[len];
                for (int i = 0; i < len; ++i) {
                    Array.set(arrayOut, i, new Integer((int)Array.getLong(arrayIn, i)));
                }
            } else if (arrayIn instanceof float[]) {
                arrayOut = new Double[len];
                for (int i = 0; i < len; ++i) {
                    Array.setDouble(arrayOut, i, new Double(Array.getFloat(arrayIn, i)));
                }
            } else if (arrayIn instanceof double[]) {
                arrayOut = new Double[len];
                for (int i = 0; i < len; ++i) {
                    Array.setDouble(arrayOut, i, new Double(Array.getDouble(arrayIn, i)));
                }
            } else {
                result = "Unhandled class: " + Utils.classToString(this.m_InputToken.getPayload().getClass());
            }
            if (arrayOut != null) {
                this.m_OutputToken = new Token(arrayOut);
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to convert array: ", e);
        }
        return result;
    }
}

