/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.id.MutableDatabaseIDHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class SetDatabaseID
extends AbstractTransformer {
    private static final long serialVersionUID = 7195919809805609634L;
    protected Integer m_ID;

    @Override
    public String globalInfo() {
        return "Updates the database ID of the database ID handler passing through with the provided 'ID' value. Attach a variable to the 'ID' option to allow for more flexibility.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("id", "ID", -1);
    }

    public void setID(Integer value) {
        this.m_ID = value;
        this.reset();
    }

    public Integer getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The new database ID to use.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "ID", this.m_ID);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{MutableDatabaseIDHandler.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{MutableDatabaseIDHandler.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            MutableDatabaseIDHandler handler = (MutableDatabaseIDHandler)this.m_InputToken.getPayload();
            handler.setDatabaseID(this.m_ID);
            this.m_OutputToken = new Token(handler);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to set database ID: " + this.m_InputToken.getPayload(), e);
        }
        return result;
    }
}

