/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class SetSystemProperty
extends AbstractTransformer {
    private static final long serialVersionUID = -6404690498752128989L;
    protected String m_Property;
    protected String m_Value;

    @Override
    public String globalInfo() {
        return "Sets a Java system property when it is executed. Use with caution!";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("property", "property", "");
        this.m_OptionManager.add("value", "value", "");
    }

    @Override
    public String getQuickInfo() {
        String value;
        String result = QuickInfoHelper.toString((OptionHandler)this, "property", this.m_Property, "Property: ");
        if (result == null) {
            result = "";
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, "value", this.m_Value, ", Value: ")) != null) {
            result = result + value;
        }
        return result;
    }

    public void setProperty(String value) {
        this.m_Property = value;
        this.reset();
    }

    public String getProperty() {
        return this.m_Property;
    }

    public String propertyTipText() {
        return "The name of the Java system property to set.";
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value for the system property.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && this.m_Property.trim().length() == 0) {
            result = "No property set!";
        }
        return result;
    }

    @Override
    protected String doExecute() {
        System.getProperties().setProperty(this.m_Property, this.m_Value);
        this.m_OutputToken = this.m_InputToken;
        return null;
    }
}

