/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.XSLTStyleSheet;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class XSLT
extends AbstractTransformer {
    private static final long serialVersionUID = -184602726110144511L;
    protected PlaceholderFile m_StyleSheet;
    protected XSLTStyleSheet m_Inline;

    @Override
    public String globalInfo() {
        return "Applies an XSLT stylesheet to the DOM document object.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("stylesheet", "styleSheet", new PlaceholderFile("."));
        this.m_OptionManager.add("inline", "inline", new XSLTStyleSheet());
    }

    public void setStyleSheet(PlaceholderFile value) {
        this.m_StyleSheet = value;
        this.reset();
    }

    public PlaceholderFile getStyleSheet() {
        return this.m_StyleSheet;
    }

    public String styleSheetTipText() {
        return "The XSLT stylesheet to apply to the input.";
    }

    public void setInline(XSLTStyleSheet value) {
        this.m_Inline = value;
        this.reset();
    }

    public XSLTStyleSheet getInline() {
        return this.m_Inline;
    }

    public String inlineTipText() {
        return "The inline XSLT stylesheet to apply to the input if the stylesheet file points to a directory.";
    }

    @Override
    public String getQuickInfo() {
        if (QuickInfoHelper.hasVariable(this, "styleSheet") || !this.m_StyleSheet.isDirectory()) {
            return super.getQuickInfo();
        }
        return QuickInfoHelper.toString((OptionHandler)this, "inline", Utils.shorten(this.m_Inline.stringValue(), 50));
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Document.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            DOMSource dsource = new DOMSource((Document)this.m_InputToken.getPayload());
            StreamSource stylesource = this.m_StyleSheet.isDirectory() ? new StreamSource(new StringReader(this.m_Inline.getValue())) : new StreamSource(this.m_StyleSheet.getAbsoluteFile());
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(stylesource);
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            StreamResult sresult = new StreamResult(ostream);
            transformer.transform(dsource, sresult);
            this.m_OutputToken = new Token(new String(ostream.toByteArray()));
        }
        catch (Exception e) {
            result = this.handleException("Failed to apply XSLT styleshet: " + this.m_StyleSheet, e);
        }
        return result;
    }
}

