/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.splitfile;

import adams.core.io.PlaceholderFile;
import adams.flow.transformer.splitfile.AbstractFileSplitter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.logging.Level;

public class SplitByNumber
extends AbstractFileSplitter {
    private static final long serialVersionUID = 6675923081135115020L;
    protected int m_NumFiles;

    @Override
    public String globalInfo() {
        return "Splits the file into a number of equally sized files.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-files", "numFiles", 1, 1, null);
    }

    public void setNumFiles(int value) {
        if (value > 0) {
            this.m_NumFiles = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of files must be >0, provided: " + value);
        }
    }

    public int getNumFiles() {
        return this.m_NumFiles;
    }

    public String numFilesTipText() {
        return "The number of files to generate.";
    }

    @Override
    protected void doSplit(PlaceholderFile file) {
        try {
            int read;
            long maxSize = (long)Math.ceil((double)file.length() / (double)this.m_NumFiles);
            int bufferSize = (int)Math.min(1024L, maxSize);
            char[] buffer = new char[bufferSize];
            FileReader reader = new FileReader(file.getAbsoluteFile());
            OutputStreamWriter writer = null;
            long count = 0L;
            while ((read = reader.read(buffer)) > -1) {
                count += (long)read;
                if (writer == null) {
                    writer = new FileWriter(this.nextFile().getAbsoluteFile());
                }
                if (count >= maxSize) {
                    int partial = (int)(maxSize - (count - (long)bufferSize));
                    if (count > maxSize) {
                        writer.write(buffer, 0, partial);
                    } else {
                        writer.write(buffer, 0, read);
                    }
                    writer.flush();
                    writer.close();
                    writer = null;
                    count = 0L;
                    if (partial >= bufferSize) continue;
                    writer = new FileWriter(this.nextFile().getAbsoluteFile());
                    writer.write(buffer, partial, read - partial);
                    count += (long)(read - partial);
                    continue;
                }
                writer.write(buffer, 0, read);
            }
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            reader.close();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to split file: " + file, e);
        }
    }
}

