/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.action.PropertiesAction;
import adams.gui.core.MenuItemComparator;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class BaseMenu
extends JMenu {
    private static final long serialVersionUID = -4652341738136722664L;

    public BaseMenu() {
    }

    public BaseMenu(String s) {
        super(s);
    }

    public BaseMenu(Action a) {
        super(a);
    }

    public BaseMenu(String s, boolean b) {
        super(s, b);
    }

    @Override
    public JMenuItem add(Action a) {
        if (a instanceof PropertiesAction) {
            return this.add(((PropertiesAction)a).getMenuItem());
        }
        return super.add(a);
    }

    @Override
    public JMenuItem insert(Action a, int pos) {
        if (a instanceof PropertiesAction) {
            return this.insert(((PropertiesAction)a).getMenuItem(), pos);
        }
        return super.insert(a, pos);
    }

    public void sort() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        for (int i = 0; i < this.getItemCount(); ++i) {
            items.add(this.getItem(i));
        }
        Collections.sort(items, new MenuItemComparator());
        this.removeAll();
        for (JMenuItem item : items) {
            this.add(item);
        }
    }

    public static BaseMenu createCascadingMenu(JMenuItem[] menuitems, int max, String more) {
        return BaseMenu.createCascadingMenu(Arrays.asList(menuitems), max, more);
    }

    public static BaseMenu createCascadingMenu(List<JMenuItem> menuitems, int max, String more) {
        BaseMenu result;
        BaseMenu current = result = new BaseMenu();
        int count = 0;
        if (max == -1) {
            max = (int)Math.floor(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().getHeight() / ((double)result.getFontMetrics(result.getFont()).getHeight() * 1.5));
        }
        for (JMenuItem menuitem : menuitems) {
            current.add(menuitem);
            if (++count < max) continue;
            count = 0;
            BaseMenu submenu = new BaseMenu(more);
            current.add(submenu);
            current = submenu;
        }
        return result;
    }
}

