/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.BaseTabbedPane;
import adams.gui.event.TabVisibilityChangeEvent;
import adams.gui.event.TabVisibilityChangeListener;
import java.awt.Component;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Icon;

public class BaseTabbedPaneWithTabHiding
extends BaseTabbedPane {
    private static final long serialVersionUID = 3893515959380608202L;
    protected Hashtable<Component, PageBackup<Component>> m_HiddenPages;
    protected HashSet<TabVisibilityChangeListener> m_TabVisibilityChangeListeners;

    public BaseTabbedPaneWithTabHiding() {
    }

    public BaseTabbedPaneWithTabHiding(int tabPlacement) {
        super(tabPlacement);
    }

    public BaseTabbedPaneWithTabHiding(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_HiddenPages = new Hashtable();
        this.m_TabVisibilityChangeListeners = new HashSet();
    }

    protected Component getHiddenComponent(String title) {
        Component result = null;
        for (Component comp : this.m_HiddenPages.keySet()) {
            PageBackup<Component> page = this.m_HiddenPages.get(comp);
            if (!page.getTitle().equals(title)) continue;
            result = comp;
            break;
        }
        return result;
    }

    public Component hideTab(Component component) {
        return this.hideTab(this.indexOfComponent(component));
    }

    public Component hideTab(String title) {
        return this.hideTab(this.indexOfTab(title));
    }

    public Component hideTab(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return null;
        }
        Component result = this.getComponentAt(index);
        this.m_HiddenPages.put(result, new PageBackup<Component>(this.getTitleAt(index), this.getIconAt(index), result, this.getToolTipTextAt(index)));
        this.removeTabAt(index);
        this.notifyTabVisibiltiyChangeListeners(new TabVisibilityChangeEvent(this, TabVisibilityChangeEvent.Type.HIDE, result));
        return result;
    }

    public void displayTab(Component component) {
        if (component == null) {
            return;
        }
        PageBackup<Component> page = this.m_HiddenPages.get(component);
        if (page != null) {
            this.addTab(page.getTitle(), page.getIcon(), page.getPayload(), page.getTip());
            this.m_HiddenPages.remove(component);
        }
        this.notifyTabVisibiltiyChangeListeners(new TabVisibilityChangeEvent(this, TabVisibilityChangeEvent.Type.DISPLAY, component));
    }

    public void displayTab(String title) {
        this.displayTab(this.getHiddenComponent(title));
    }

    @Override
    public void removeAll() {
        this.m_HiddenPages.clear();
        super.removeAll();
    }

    public void addHiddenTab(String title, Icon icon, Component component, String tip) {
        this.m_HiddenPages.put(component, new PageBackup<Component>(title, icon, component, tip));
    }

    public void addHiddenTab(String title, Icon icon, Component component) {
        this.addHiddenTab(title, icon, component, null);
    }

    public void addHiddenTab(String title, Component component) {
        this.addHiddenTab(title, null, component, null);
    }

    public boolean isHidden(Component comp) {
        return this.m_HiddenPages.containsKey(comp);
    }

    public boolean isHidden(String title) {
        Component comp = this.getHiddenComponent(title);
        boolean result = comp != null && this.m_HiddenPages.containsKey(comp);
        return result;
    }

    public boolean removeHidden(Component comp) {
        return this.m_HiddenPages.remove(comp) != null;
    }

    public boolean removeHidden(String title) {
        Component comp = this.getHiddenComponent(title);
        return comp != null && this.m_HiddenPages.remove(comp) != null;
    }

    public void addTabVisibilityChangeListener(TabVisibilityChangeListener l) {
        this.m_TabVisibilityChangeListeners.add(l);
    }

    public void remvoeTabVisibilityChangeListener(TabVisibilityChangeListener l) {
        this.m_TabVisibilityChangeListeners.remove(l);
    }

    protected void notifyTabVisibiltiyChangeListeners(TabVisibilityChangeEvent e) {
        Iterator<TabVisibilityChangeListener> iter = this.m_TabVisibilityChangeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().tabVisibilityChanged(e);
        }
    }

    public static class PageBackup<T>
    implements Serializable {
        private static final long serialVersionUID = -8446679315630104192L;
        protected String m_Title;
        protected Icon m_Icon;
        protected T m_Payload;
        protected String m_Tip;

        public PageBackup(String title, Icon icon, T payload, String tip) {
            this.m_Title = title;
            this.m_Icon = icon;
            this.m_Payload = payload;
            this.m_Tip = tip;
        }

        public Icon getIcon() {
            return this.m_Icon;
        }

        public T getPayload() {
            return this.m_Payload;
        }

        public String getTip() {
            return this.m_Tip;
        }

        public String getTitle() {
            return this.m_Title;
        }
    }
}

