/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextPane;

public class ParameterPanel
extends BasePanel {
    private static final long serialVersionUID = 7164103981772081436L;
    protected List<JCheckBox> m_CheckBoxes;
    protected List<JLabel> m_Labels;
    protected List<Component> m_Parameters;
    protected int m_GapHorizontal;
    protected int m_GapVertical;
    protected boolean m_UseCheckBoxes;
    protected Dimension m_PreferredDimensionJSpinner;

    public ParameterPanel() {
        this(false);
    }

    public ParameterPanel(boolean useCheckBoxes) {
        this(5, 2, useCheckBoxes);
    }

    public ParameterPanel(int hgap, int vgap) {
        this(hgap, vgap, false);
    }

    public ParameterPanel(int hgap, int vgap, boolean useCheckBoxes) {
        this.m_GapHorizontal = hgap;
        this.m_GapVertical = vgap;
        this.m_UseCheckBoxes = useCheckBoxes;
        this.update();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CheckBoxes = new ArrayList<JCheckBox>();
        this.m_Labels = new ArrayList<JLabel>();
        this.m_Parameters = new ArrayList<Component>();
        this.m_PreferredDimensionJSpinner = new Dimension(100, 20);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.update();
    }

    public void clearParameters() {
        this.m_CheckBoxes.clear();
        this.m_Labels.clear();
        this.m_Parameters.clear();
        this.update();
    }

    public boolean useCheckBoxes() {
        return this.m_UseCheckBoxes;
    }

    public void setPreferredDimensionJSpinner(Dimension value) {
        this.m_PreferredDimensionJSpinner = (Dimension)value.clone();
        this.update();
    }

    public Dimension getPreferredDimensionJSpinner() {
        return this.m_PreferredDimensionJSpinner;
    }

    public int addParameter(String label, Component comp) {
        return this.addParameter(false, label, comp);
    }

    public int addParameter(boolean checked, String label, Component comp) {
        return this.addParameter(-1, checked, label, comp);
    }

    public int addParameter(AbstractChooserPanel chooser) {
        return this.addParameter(false, chooser);
    }

    public int addParameter(boolean checked, AbstractChooserPanel chooser) {
        return this.addParameter(-1, false, chooser);
    }

    public int addParameter(int index, String label, Component comp) {
        return this.addParameter(index, false, label, comp);
    }

    public int addParameter(int index, boolean checked, String label, Component comp) {
        GridBagConstraints con;
        JLabel lbl = new JLabel(label.replace("_", ""));
        lbl.setDisplayedMnemonic(GUIHelper.getMnemonic(label));
        lbl.setLabelFor(comp);
        JCheckBox check = this.m_UseCheckBoxes ? new JCheckBox("", checked) : null;
        if (comp instanceof JTextArea) {
            comp = new BaseScrollPane(comp);
        } else if (comp instanceof JTextPane) {
            comp = new BaseScrollPane(comp);
        }
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        if (this.m_UseCheckBoxes) {
            con = new GridBagConstraints();
            con.anchor = 17;
            con.gridy = 0;
            con.gridx = 0;
            con.insets = new Insets(this.m_GapVertical, this.m_GapHorizontal, this.m_GapVertical, this.m_GapHorizontal);
            layout.setConstraints(check, con);
            panel.add(check);
        }
        con = new GridBagConstraints();
        con.anchor = 17;
        con.gridy = 0;
        con.gridx = 0;
        if (this.m_UseCheckBoxes) {
            ++con.gridx;
        }
        con.ipadx = 20;
        con.insets = new Insets(this.m_GapVertical, this.m_GapHorizontal, this.m_GapVertical, this.m_GapHorizontal);
        layout.setConstraints(lbl, con);
        panel.add(lbl);
        con = new GridBagConstraints();
        con.anchor = 17;
        con.fill = 2;
        con.gridy = 0;
        con.gridx = 1;
        if (this.m_UseCheckBoxes) {
            ++con.gridx;
        }
        con.weightx = 100.0;
        con.ipadx = 20;
        con.insets = new Insets(this.m_GapVertical, this.m_GapHorizontal, this.m_GapVertical, this.m_GapHorizontal);
        layout.setConstraints(comp, con);
        panel.add(comp);
        if (index == -1) {
            if (this.m_UseCheckBoxes) {
                this.m_CheckBoxes.add(check);
            }
            this.m_Labels.add(lbl);
            index = this.m_Parameters.size();
            this.m_Parameters.add(comp);
        } else {
            if (this.m_UseCheckBoxes) {
                this.m_CheckBoxes.add(index, check);
            }
            this.m_Labels.add(index, lbl);
            this.m_Parameters.add(index, comp);
        }
        this.update();
        return index;
    }

    public void addParameter(int index, AbstractChooserPanel chooser) {
        this.addParameter(index, false, chooser);
    }

    public int addParameter(int index, boolean checked, AbstractChooserPanel chooser) {
        GridBagConstraints con;
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        JCheckBox check = this.m_UseCheckBoxes ? new JCheckBox("", checked) : null;
        if (this.m_UseCheckBoxes) {
            con = new GridBagConstraints();
            con.anchor = 17;
            con.gridy = 0;
            con.gridx = 0;
            con.insets = new Insets(this.m_GapVertical + 1, this.m_GapHorizontal, this.m_GapVertical + 1, this.m_GapHorizontal);
            layout.setConstraints(check, con);
            this.add(check);
        }
        con = new GridBagConstraints();
        con.anchor = 17;
        con.fill = 2;
        con.gridy = 0;
        con.gridx = 0;
        con.weightx = 100.0;
        con.ipadx = 20;
        con.insets = new Insets(this.m_GapVertical, this.m_GapHorizontal, this.m_GapVertical, this.m_GapHorizontal);
        layout.setConstraints(chooser, con);
        panel.add(chooser);
        panel = new JPanel(new FlowLayout(0));
        panel.add(chooser);
        if (index == -1) {
            if (this.m_UseCheckBoxes) {
                this.m_CheckBoxes.add(check);
            }
            this.m_Labels.add(chooser.getPrefixLabel());
            index = this.m_Parameters.size();
            this.m_Parameters.add(chooser);
        } else {
            if (this.m_UseCheckBoxes) {
                this.m_CheckBoxes.add(index, check);
            }
            this.m_Labels.add(index, chooser.getPrefixLabel());
            this.m_Parameters.add(index, chooser);
        }
        this.update();
        return index;
    }

    public void removeParameter(int index) {
        this.m_Labels.remove(index);
        this.m_Parameters.remove(index);
        this.update();
    }

    public Component getParameter(int index) {
        return this.m_Parameters.get(index);
    }

    public int getParameterCount() {
        return this.m_Parameters.size();
    }

    public JLabel getLabel(int index) {
        return this.m_Labels.get(index);
    }

    public JCheckBox getCheckBox(int index) {
        if (this.m_UseCheckBoxes) {
            return this.m_CheckBoxes.get(index);
        }
        return null;
    }

    public boolean isChecked(int index) {
        if (!this.m_UseCheckBoxes) {
            return false;
        }
        return this.m_CheckBoxes.get(index).isSelected();
    }

    public void setToolTipText(int index, String text, boolean label, boolean comp) {
        this.setToolTipText(index, text, false, label, comp);
    }

    public void setToolTipText(int index, String text, boolean check, boolean label, boolean comp) {
        if (this.m_UseCheckBoxes && check) {
            this.getCheckBox(index).setToolTipText(text);
        }
        if (label) {
            this.getLabel(index).setToolTipText(text);
        }
        if (comp && this.getParameter(index) instanceof JComponent) {
            ((JComponent)this.getParameter(index)).setToolTipText(text);
        }
    }

    protected void update() {
        GridBagConstraints con;
        int i;
        this.removeAll();
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        for (i = 0; i < this.m_Parameters.size(); ++i) {
            if (!(this.m_Parameters.get(i) instanceof JSpinner)) continue;
            ((JSpinner)this.m_Parameters.get(i)).setPreferredSize((Dimension)this.m_PreferredDimensionJSpinner.clone());
        }
        for (i = 0; i < this.m_Labels.size(); ++i) {
            if (this.m_UseCheckBoxes) {
                con = new GridBagConstraints();
                con.anchor = 17;
                con.gridy = i;
                con.gridx = 0;
                con.insets = new Insets(this.m_GapVertical + 1, this.m_GapHorizontal, this.m_GapVertical + 1, this.m_GapHorizontal);
                layout.setConstraints(this.m_CheckBoxes.get(i), con);
                this.add(this.m_CheckBoxes.get(i));
            }
            con = new GridBagConstraints();
            con.anchor = 17;
            con.gridy = i;
            con.gridx = 0;
            if (this.m_UseCheckBoxes) {
                ++con.gridx;
            }
            con.ipadx = 20;
            con.insets = new Insets(this.m_GapVertical + 1, 5, this.m_GapVertical + 1, 5);
            layout.setConstraints(this.m_Labels.get(i), con);
            this.add(this.m_Labels.get(i));
            con = new GridBagConstraints();
            con.anchor = 17;
            con.fill = 2;
            con.gridy = i;
            con.gridx = 1;
            if (this.m_UseCheckBoxes) {
                ++con.gridx;
            }
            con.weightx = 100.0;
            con.ipadx = 20;
            con.gridwidth = 0;
            con.insets = new Insets(this.m_GapVertical + 1, 5, this.m_GapVertical + 1, 5);
            layout.setConstraints(this.m_Parameters.get(i), con);
            this.add(this.m_Parameters.get(i));
        }
        JPanel panel = new JPanel();
        con = new GridBagConstraints();
        con.anchor = 17;
        con.fill = 1;
        con.gridy = this.m_Labels.size();
        con.gridx = 0;
        con.weighty = 100.0;
        con.gridwidth = 0;
        layout.setConstraints(panel, con);
        this.add(panel);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            if (this.m_UseCheckBoxes) {
                this.m_CheckBoxes.get(i).setEnabled(enabled);
            }
            this.m_Parameters.get(i).setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }
}

