/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.data.statistics.ArrayHistogram;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.core.AbstractActor;
import adams.flow.sink.SimplePlot;
import adams.flow.source.StorageValue;
import adams.flow.transformer.ArrayToSequence;
import adams.flow.transformer.MakePlotContainer;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.GUIHelper;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SpreadSheetCellRenderer;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.TableRowRange;
import adams.gui.event.PopupMenuListener;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.statistics.HistogramFactory;
import gnu.trove.list.array.TDoubleArrayList;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SpreadSheetTable
extends SortableAndSearchableTable
implements SpreadSheetSupporter {
    private static final long serialVersionUID = 1333317577811620786L;
    protected PopupMenuCustomizer m_HeaderPopupMenuCustomizer;
    protected PopupMenuCustomizer m_CellPopupMenuCustomizer;
    protected SpreadSheetFileChooser m_FileChooser;
    protected ArrayHistogram m_Histogram;
    protected SimplePlot m_Plot;

    public SpreadSheetTable(SpreadSheet sheet) {
        this(new SpreadSheetTableModel(sheet));
    }

    public SpreadSheetTable(SpreadSheetTableModel model) {
        super(model);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_HeaderPopupMenuCustomizer = null;
        this.m_CellPopupMenuCustomizer = null;
        this.m_Histogram = new ArrayHistogram();
        this.m_Plot = new SimplePlot();
        this.addHeaderPopupMenuListener(new PopupMenuListener(){

            @Override
            public void showPopupMenu(MouseEvent e) {
                SpreadSheetTable.this.showHeaderPopupMenu(e);
            }
        });
        this.addCellPopupMenuListener(new PopupMenuListener(){

            @Override
            public void showPopupMenu(MouseEvent e) {
                SpreadSheetTable.this.showCellPopupMenu(e);
            }
        });
    }

    protected void setCustomCellRenderer() {
        SpreadSheetCellRenderer renderer = new SpreadSheetCellRenderer();
        TableColumnModel colModel = this.getColumnModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            colModel.getColumn(i).setCellRenderer(renderer);
        }
    }

    @Override
    public void setModel(TableModel model) {
        SpreadSheetTableModel modelOld = (SpreadSheetTableModel)this.getUnsortedModel();
        TableModelListener[] listeners = null;
        if (modelOld != null) {
            listeners = (TableModelListener[])modelOld.getListeners(TableModelListener.class);
        }
        super.setModel(model);
        this.setCustomCellRenderer();
        if (listeners != null) {
            for (TableModelListener listener : listeners) {
                model.addTableModelListener(listener);
                listener.tableChanged(new TableModelEvent(model));
            }
        }
    }

    @Override
    protected boolean initialUseOptimalColumnWidths() {
        return true;
    }

    @Override
    protected boolean initialSortNewTableModel() {
        return false;
    }

    @Override
    protected Class getTableModelClass() {
        return SpreadSheetTableModel.class;
    }

    @Override
    protected TableModel createDefaultDataModel() {
        return new SpreadSheetTableModel();
    }

    public Cell getCellAt(int rowIndex, int columnIndex) {
        SpreadSheetTableModel sheetmodel = (SpreadSheetTableModel)this.getUnsortedModel();
        Cell result = sheetmodel.getCellAt(this.getActualRow(rowIndex), columnIndex);
        return result;
    }

    public void setNumDecimals(int value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setNumDecimals(value);
    }

    public int getNumDecimals() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getNumDecimals();
    }

    @Override
    public SpreadSheet toSpreadSheet() {
        return this.toSpreadSheet(TableRowRange.ALL);
    }

    public SpreadSheet toSpreadSheet(TableRowRange range) {
        SpreadSheet result;
        SpreadSheet full = ((SpreadSheetTableModel)this.getUnsortedModel()).toSpreadSheet();
        switch (range) {
            case ALL: {
                result = full;
                break;
            }
            case SELECTED: {
                result = full.getHeader();
                int[] indices = this.getSelectedRows();
                for (int i = 0; i < indices.length; ++i) {
                    result.addRow().assign(full.getRow(this.getActualRow(indices[i])));
                }
                break;
            }
            case VISIBLE: {
                result = full.getHeader();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    result.addRow().assign(full.getRow(this.getActualRow(i)));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled row range: " + (Object)((Object)range));
            }
        }
        return result;
    }

    protected synchronized SpreadSheetFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
            this.m_FileChooser.setMultiSelectionEnabled(false);
        }
        return this.m_FileChooser;
    }

    protected void showHeaderPopupMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        final int col = this.columnAtPoint(e.getPoint());
        JMenuItem menuitem = new JMenuItem("Copy column name", GUIHelper.getEmptyIcon());
        menuitem.setEnabled(this.getShowRowColumn() && col > 0 || !this.getShowRowColumn());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int actCol = col;
                if (SpreadSheetTable.this.getShowRowColumn()) {
                    --actCol;
                }
                GUIHelper.copyToClipboard(((SpreadSheetTableModel)SpreadSheetTable.this.getUnsortedModel()).toSpreadSheet().getColumnName(actCol));
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Copy column", GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(this.getShowRowColumn() && col > 0 || !this.getShowRowColumn());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int actCol = col;
                if (SpreadSheetTable.this.getShowRowColumn()) {
                    --actCol;
                }
                SpreadSheet sheet = ((SpreadSheetTableModel)SpreadSheetTable.this.getUnsortedModel()).toSpreadSheet();
                StringBuilder content = new StringBuilder();
                String sep = System.getProperty("line.separator");
                content.append(sheet.getColumnName(actCol) + sep);
                for (int i = 0; i < sheet.getRowCount(); ++i) {
                    if (!sheet.hasCell(i, actCol) || sheet.getCell(i, actCol).isMissing()) {
                        content.append(sep);
                        continue;
                    }
                    content.append(sheet.getCell(i, actCol).getContent() + sep);
                }
                GUIHelper.copyToClipboard(content.toString());
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Rename column", GUIHelper.getEmptyIcon());
        menuitem.setEnabled(this.getShowRowColumn() && col > 0 || !this.getShowRowColumn());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int actCol = col;
                if (SpreadSheetTable.this.getShowRowColumn()) {
                    --actCol;
                }
                SpreadSheet sheet = ((SpreadSheetTableModel)SpreadSheetTable.this.getUnsortedModel()).toSpreadSheet();
                String newName = sheet.getColumnName(actCol);
                newName = GUIHelper.showInputDialog(SpreadSheetTable.this.getParent(), "Please enter new column name", newName);
                if (newName == null) {
                    return;
                }
                sheet = sheet.getClone();
                sheet.getHeaderRow().getCell(actCol).setContent(newName);
                SpreadSheetTable.this.setModel(new SpreadSheetTableModel(sheet));
            }
        });
        menu.add(menuitem);
        final boolean asc = !e.isShiftDown();
        menuitem = asc ? new JMenuItem("Sort (asc)", GUIHelper.getIcon("sort-ascending.png")) : new JMenuItem("Sort (desc)", GUIHelper.getIcon("sort-descending.png"));
        menuitem.setEnabled(this.getShowRowColumn() && col > 0 || !this.getShowRowColumn());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheet sheet = SpreadSheetTable.this.toSpreadSheet();
                if (SpreadSheetTable.this.getShowRowColumn()) {
                    sheet.sort(col - 1, asc);
                } else {
                    sheet.sort(col, asc);
                }
                SpreadSheetTable.this.setModel(new SpreadSheetTableModel(sheet));
            }
        });
        menu.add(menuitem);
        menu.addSeparator();
        menuitem = new JMenuItem("Remove column", GUIHelper.getIcon("delete.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheet sheet = SpreadSheetTable.this.toSpreadSheet();
                if (SpreadSheetTable.this.getShowRowColumn()) {
                    sheet.removeColumn(col - 1);
                } else {
                    sheet.removeColumn(col);
                }
                SpreadSheetTable.this.setModel(new SpreadSheetTableModel(sheet));
            }
        });
        menu.add(menuitem);
        menu.addSeparator();
        menuitem = new JMenuItem("Plot", GUIHelper.getIcon("plot.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheetTable.this.plot(SpreadSheetTable.this.toSpreadSheet(), true, SpreadSheetTable.this.getShowRowColumn() ? col - 1 : col);
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Histogram", GUIHelper.getIcon("histogram.png"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheetTable.this.histogram(SpreadSheetTable.this.toSpreadSheet(), true, SpreadSheetTable.this.getShowRowColumn() ? col - 1 : col);
            }
        });
        menu.add(menuitem);
        if (this.m_HeaderPopupMenuCustomizer != null) {
            this.m_HeaderPopupMenuCustomizer.customizePopupMenu(e, menu);
        }
        menu.show(this.getTableHeader(), e.getX(), e.getY());
    }

    protected void showCellPopupMenu(final MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuitem = this.getSelectedRowCount() > 1 ? new JMenuItem("Copy rows") : new JMenuItem("Copy row");
        menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(this.getSelectedRowCount() > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.copyToClipboard();
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Copy cell");
        menuitem.setIcon(GUIHelper.getEmptyIcon());
        menuitem.setEnabled(this.getSelectedRowCount() == 1);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int row = SpreadSheetTable.this.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                int col = SpreadSheetTable.this.columnAtPoint(e.getPoint());
                if (col == -1) {
                    return;
                }
                GUIHelper.copyToClipboard("" + SpreadSheetTable.this.getValueAt(row, col));
            }
        });
        menu.add(menuitem);
        JMenu submenu = new JMenu("Save");
        submenu.setIcon(GUIHelper.getIcon("save.gif"));
        menu.add(submenu);
        menuitem = new JMenuItem("Save all...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.saveAs(TableRowRange.ALL);
            }
        });
        submenu.add(menuitem);
        menuitem = new JMenuItem("Save selected...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.saveAs(TableRowRange.SELECTED);
            }
        });
        submenu.add(menuitem);
        menuitem = new JMenuItem("Save visible...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.saveAs(TableRowRange.VISIBLE);
            }
        });
        submenu.add(menuitem);
        menu.addSeparator();
        menuitem = new JMenuItem("Plot", GUIHelper.getIcon("plot.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int row = SpreadSheetTable.this.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                SpreadSheetTable.this.plot(SpreadSheetTable.this.toSpreadSheet(), false, row);
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Histogram", GUIHelper.getIcon("histogram.png"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int row = SpreadSheetTable.this.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                SpreadSheetTable.this.histogram(SpreadSheetTable.this.toSpreadSheet(), false, row);
            }
        });
        menu.add(menuitem);
        menu.addSeparator();
        menuitem = new JCheckBoxMenuItem("Show formulas");
        menuitem.setIcon(GUIHelper.getIcon("formula.png"));
        menuitem.setEnabled(this.getRowCount() > 0);
        menuitem.setSelected(this.getShowFormulas());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.setShowFormulas(!SpreadSheetTable.this.getShowFormulas());
            }
        });
        menu.add(menuitem);
        if (this.m_CellPopupMenuCustomizer != null) {
            this.m_CellPopupMenuCustomizer.customizePopupMenu(e, menu);
        }
        menu.show(this, e.getX(), e.getY());
    }

    public void setHeaderPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_HeaderPopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getHeaderPopupMenuCustomizer() {
        return this.m_HeaderPopupMenuCustomizer;
    }

    public void setCellPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_CellPopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getCellPopupMenuCustomizer() {
        return this.m_CellPopupMenuCustomizer;
    }

    public boolean hasNegativeBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).hasNegativeBackground();
    }

    public void setNegativeBackground(Color value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setNegativeBackground(value);
    }

    public Color getNegativeBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getNegativeBackground();
    }

    public boolean hasPositiveBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).hasPositiveBackground();
    }

    public void setPositiveBackground(Color value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setPositiveBackground(value);
    }

    public Color getPositiveBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getPositiveBackground();
    }

    public void setShowFormulas(boolean value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setShowFormulas(value);
    }

    public boolean getShowFormulas() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getShowFormulas();
    }

    public void setShowRowColumn(boolean value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setShowRowColumn(value);
    }

    public boolean getShowRowColumn() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getShowRowColumn();
    }

    public void sort(RowComparator comparator) {
        this.toSpreadSheet().sort(comparator);
        ((SpreadSheetTableModel)this.getUnsortedModel()).fireTableDataChanged();
    }

    protected void histogram(SpreadSheet sheet, boolean isColumn, int index) {
        HistogramFactory.SetupDialog setup = GUIHelper.getParentDialog(this) != null ? HistogramFactory.getSetupDialog(GUIHelper.getParentDialog(this), Dialog.ModalityType.DOCUMENT_MODAL) : HistogramFactory.getSetupDialog(GUIHelper.getParentFrame(this), true);
        setup.setDefaultCloseOperation(2);
        setup.setCurrent(this.m_Histogram);
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return;
        }
        this.m_Histogram = (ArrayHistogram)setup.getCurrent();
        TDoubleArrayList list = new TDoubleArrayList();
        if (isColumn) {
            for (int i = 0; i < sheet.getRowCount(); ++i) {
                if (!sheet.hasCell(i, index) || !sheet.getCell(i, index).isNumeric()) continue;
                list.add(sheet.getCell(i, index).toDouble().doubleValue());
            }
        } else {
            for (int i = 0; i < sheet.getColumnCount(); ++i) {
                if (!sheet.hasCell(index, i) || !sheet.getCell(index, i).isNumeric()) continue;
                list.add(sheet.getCell(index, i).toDouble().doubleValue());
            }
        }
        this.m_Histogram.clear();
        HistogramFactory.Dialog dialog = GUIHelper.getParentDialog(this) != null ? HistogramFactory.getDialog(GUIHelper.getParentDialog(this), Dialog.ModalityType.MODELESS) : HistogramFactory.getDialog(GUIHelper.getParentFrame(this), false);
        dialog.setDefaultCloseOperation(2);
        if (isColumn) {
            dialog.add(this.m_Histogram, list.toArray(), "Column " + (index + 1) + "/" + sheet.getColumnName(index));
        } else {
            dialog.add(this.m_Histogram, list.toArray(), "Row " + (index + 1));
        }
        dialog.setVisible(true);
    }

    protected void plot(SpreadSheet sheet, boolean isColumn, int index) {
        GenericObjectEditorDialog setup = GUIHelper.getParentDialog(this) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog(this), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame(this), true);
        setup.setDefaultCloseOperation(2);
        setup.getGOEEditor().setClassType(AbstractActor.class);
        setup.getGOEEditor().setCanChangeClassInDialog(false);
        setup.setCurrent(this.m_Plot);
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return;
        }
        this.m_Plot = (SimplePlot)setup.getCurrent();
        final ArrayList<Double> list = new ArrayList<Double>();
        if (isColumn) {
            for (int i = 0; i < sheet.getRowCount(); ++i) {
                if (!sheet.hasCell(i, index) || !sheet.getCell(i, index).isNumeric()) continue;
                list.add(sheet.getCell(i, index).toDouble());
            }
        } else {
            for (int i = 0; i < sheet.getColumnCount(); ++i) {
                if (!sheet.hasCell(index, i) || !sheet.getCell(index, i).isNumeric()) continue;
                list.add(sheet.getCell(index, i).toDouble());
            }
        }
        final String title = isColumn ? "Column " + (index + 1) + "/" + sheet.getColumnName(index) : "Row " + (index + 1);
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                Flow flow = new Flow();
                StorageValue sv = new StorageValue();
                sv.setStorageName(new StorageName("values"));
                flow.add(sv);
                ArrayToSequence a2s = new ArrayToSequence();
                flow.add(a2s);
                MakePlotContainer mpc = new MakePlotContainer();
                mpc.setPlotName(title);
                flow.add(mpc);
                SimplePlot plot = (SimplePlot)SpreadSheetTable.this.m_Plot.shallowCopy();
                plot.setShortTitle(true);
                plot.setName(title);
                flow.add(plot);
                flow.setUp();
                flow.getStorage().put(new StorageName("values"), list.toArray(new Double[list.size()]));
                flow.execute();
                flow.wrapUp();
                return null;
            }
        };
        worker.execute();
    }

    protected void saveAs(TableRowRange range) {
        int retVal = this.getFileChooser().showSaveDialog(GUIHelper.getParentComponent(this));
        if (retVal != 0) {
            return;
        }
        File file = this.getFileChooser().getSelectedFile();
        SpreadSheetWriter writer = (SpreadSheetWriter)this.getFileChooser().getWriter();
        if (!writer.write(this.toSpreadSheet(range), file)) {
            GUIHelper.showErrorMessage(this, "Failed to save spreadsheet to the following file:\n" + file);
        }
    }
}

