/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.License;
import adams.core.Utils;
import adams.core.annotation.MixedCopyright;
import adams.core.io.FileUtils;
import adams.gui.chooser.TextFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTextPane;
import adams.gui.core.BaseTextPaneWithWordWrap;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

@MixedCopyright(copyright="Patrick Chan and Addision Wesley, Java Developers Almanac 2000", license=License.BSD3, url="http://java.sun.com/developer/codesamples/examplets/javax.swing.undo/236.html", note="Undo/redo")
public class StyledTextEditorPanel
extends BasePanel {
    private static final long serialVersionUID = 3594108882868668611L;
    protected BaseTextPaneWithWordWrap m_TextPane;
    protected boolean m_Modified;
    protected boolean m_IgnoreChanges;
    protected transient TextFileChooser m_FileChooser;
    protected UndoManager m_Undo;
    protected String m_LastFind;
    protected HashSet<ChangeListener> m_ChangeListeners;
    protected File m_CurrentFile;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CurrentFile = null;
        this.m_ChangeListeners = new HashSet();
        this.m_Undo = new UndoManager();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TextPane = this.newBaseTextPane();
        this.m_TextPane.setFont(GUIHelper.getMonospacedFont());
        this.add((Component)this.m_TextPane, "Center");
        this.m_TextPane.getTextPane().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                StyledTextEditorPanel.this.m_Modified = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                StyledTextEditorPanel.this.m_Modified = true;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                StyledTextEditorPanel.this.m_Modified = true;
            }
        });
        this.m_TextPane.getTextPane().getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                StyledTextEditorPanel.this.m_Modified = true;
                StyledTextEditorPanel.this.m_Undo.addEdit(evt.getEdit());
                StyledTextEditorPanel.this.notifyChangeListeners();
            }
        });
        this.m_TextPane.getActionMap().put("Undo", new AbstractAction("Undo"){
            private static final long serialVersionUID = -3023997491519283074L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyledTextEditorPanel.this.undo();
            }
        });
        this.m_TextPane.getInputMap().put(GUIHelper.getKeyStroke("control Z"), "Undo");
        this.m_TextPane.getActionMap().put("Redo", new AbstractAction("Redo"){
            private static final long serialVersionUID = -3579642465298206034L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyledTextEditorPanel.this.redo();
            }
        });
        this.m_TextPane.getInputMap().put(GUIHelper.getKeyStroke("control Y"), "Redo");
        this.setSize(600, 800);
    }

    protected TextFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new TextFileChooser();
        }
        return this.m_FileChooser;
    }

    protected BaseTextPaneWithWordWrap newBaseTextPane() {
        return new BaseTextPaneWithWordWrap();
    }

    public void setModified(boolean value) {
        this.m_Modified = value;
        if (!this.m_Modified) {
            this.m_Undo.discardAllEdits();
        }
        this.notifyChangeListeners();
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public void setContent(String value) {
        this.m_TextPane.getTextPane().setText(value);
    }

    public String getContent() {
        return this.m_TextPane.getTextPane().getText();
    }

    public void setEditable(boolean value) {
        this.m_TextPane.getTextPane().setEditable(value);
    }

    public boolean isEditable() {
        return this.m_TextPane.getTextPane().isEditable();
    }

    public void setTextFont(Font value) {
        this.m_TextPane.setFont(value);
    }

    public Font getTextFont() {
        return this.m_TextPane.getFont();
    }

    public String getLastFind() {
        return this.m_LastFind;
    }

    public BaseTextPane getTextPane() {
        return this.m_TextPane.getTextPane();
    }

    public Document getDocument() {
        return this.m_TextPane.getTextPane().getDocument();
    }

    public void setCaretPosition(int value) {
        this.m_TextPane.getTextPane().setCaretPosition(value);
    }

    public int getCaretPosition() {
        return this.m_TextPane.getTextPane().getCaretPosition();
    }

    public void setWordWrap(boolean value) {
        this.m_TextPane.setWordWrap(value);
    }

    public boolean getWordWrap() {
        return this.m_TextPane.getWordWrap();
    }

    public boolean checkForModified() {
        boolean result;
        boolean bl = result = !this.isModified();
        if (!result) {
            String msg = "Content not saved - save?";
            int retVal = GUIHelper.showConfirmMessage(this, msg, "Content not saved");
            switch (retVal) {
                case 0: {
                    this.saveAs();
                    result = !this.isModified();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    public void open() {
        int retVal = this.getFileChooser().showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        this.open(this.getFileChooser().getSelectedFile(), this.getFileChooser().getEncoding());
    }

    public void open(File file) {
        this.open(file, null);
    }

    public void open(File file, String encoding) {
        if (encoding == null || encoding.isEmpty()) {
            encoding = "UTF-8";
        }
        List<String> content = FileUtils.loadFromFile(file, encoding);
        this.setContent(Utils.flatten(content, "\n"));
        this.setModified(false);
        this.m_CurrentFile = file;
        this.notifyChangeListeners();
    }

    public void save() {
        if (this.m_CurrentFile == null) {
            this.saveAs();
        } else {
            this.save(this.m_CurrentFile);
        }
    }

    public void saveAs() {
        int retVal = this.getFileChooser().showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        this.save(this.getFileChooser().getSelectedFile());
    }

    protected void save(File file) {
        if (!FileUtils.writeToFile(file.getAbsolutePath(), (Object)this.m_TextPane.getTextPane().getText(), false)) {
            GUIHelper.showErrorMessage(this, "Error saving content to file '" + file + "'!");
        } else {
            this.m_CurrentFile = file;
            this.m_Modified = false;
        }
        this.notifyChangeListeners();
    }

    public void clear() {
        try {
            this.m_TextPane.getTextPane().getDocument().remove(0, this.m_TextPane.getTextPane().getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_Modified = false;
        this.notifyChangeListeners();
    }

    public boolean canUndo() {
        try {
            return this.m_Undo.canUndo();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void undo() {
        try {
            if (this.m_Undo.canUndo()) {
                this.m_Undo.undo();
            }
            if (!this.m_Undo.canUndo()) {
                this.m_Modified = false;
            }
            this.notifyChangeListeners();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canRedo() {
        try {
            return this.m_Undo.canRedo();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void redo() {
        try {
            if (this.m_Undo.canRedo()) {
                this.m_Undo.redo();
                this.m_Modified = true;
                this.notifyChangeListeners();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canCut() {
        return this.isEditable() && this.m_TextPane.getTextPane().getSelectedText() != null;
    }

    public void cut() {
        this.m_TextPane.getTextPane().cut();
        this.notifyChangeListeners();
    }

    public boolean canCopy() {
        return this.m_TextPane.getTextPane().getSelectedText() != null;
    }

    public void copy() {
        if (this.m_TextPane.getTextPane().getSelectedText() == null) {
            GUIHelper.copyToClipboard(this.m_TextPane.getTextPane().getText());
        } else {
            this.m_TextPane.getTextPane().copy();
        }
    }

    public boolean canPaste() {
        return this.isEditable() && GUIHelper.canPasteStringFromClipboard();
    }

    public void paste() {
        this.m_TextPane.getTextPane().paste();
        this.notifyChangeListeners();
    }

    public void selectAll() {
        this.m_TextPane.getTextPane().selectAll();
    }

    public void find() {
        String search = GUIHelper.showInputDialog(GUIHelper.getParentComponent(this), "Enter search string", this.m_LastFind);
        if (search == null) {
            return;
        }
        int index = this.m_TextPane.getTextPane().getText().indexOf(search, this.m_TextPane.getTextPane().getCaretPosition());
        if (index > -1) {
            this.m_LastFind = search;
            this.m_TextPane.getTextPane().setCaretPosition(index + search.length());
            this.m_TextPane.getTextPane().setSelectionStart(index);
            this.m_TextPane.getTextPane().setSelectionEnd(index + search.length());
        } else {
            GUIHelper.showErrorMessage(this, "Search string '" + search + "' not found!");
        }
        this.notifyChangeListeners();
    }

    public void findNext() {
        int index = this.m_TextPane.getTextPane().getText().indexOf(this.m_LastFind, this.m_TextPane.getTextPane().getCaretPosition());
        if (index > -1) {
            this.m_TextPane.getTextPane().setCaretPosition(index + this.m_LastFind.length());
            this.m_TextPane.getTextPane().setSelectionStart(index);
            this.m_TextPane.getTextPane().setSelectionEnd(index + this.m_LastFind.length());
        } else {
            GUIHelper.showErrorMessage(this, "Search string '" + this.m_LastFind + "' not found!");
        }
        this.notifyChangeListeners();
    }

    public void printText() {
        this.m_TextPane.getTextPane().printText();
    }

    public void selectFont() {
        this.m_TextPane.getTextPane().selectFont();
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    protected synchronized void notifyChangeListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(e);
        }
    }
}

