/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.io.FileFormatHandler;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.goe.GenericObjectEditorPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractFileExportDialog<T>
extends ApprovalDialog {
    private static final long serialVersionUID = 201725070566669323L;
    protected ParameterPanel m_PanelParams;
    protected GenericObjectEditorPanel m_PanelGOE;
    protected FileChooserPanel m_PanelFile;

    public AbstractFileExportDialog(Dialog owner) {
        super(owner);
    }

    public AbstractFileExportDialog(Dialog owner, Dialog.ModalityType modality) {
        super(owner, modality);
    }

    public AbstractFileExportDialog(Frame owner) {
        super(owner);
    }

    public AbstractFileExportDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setTitle(this.getDefaultTitle());
        this.m_PanelParams = new ParameterPanel();
        this.getContentPane().add((Component)this.m_PanelParams, "Center");
        this.m_PanelGOE = this.createGOE();
        this.m_PanelGOE.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractFileExportDialog.this.updateFileChooser();
            }
        });
        this.m_PanelParams.addParameter("For_mat", (Component)this.m_PanelGOE);
        this.m_PanelFile = new FileChooserPanel();
        this.m_PanelFile.setPromptOverwriteFile(true);
        this.m_PanelFile.setUseSaveDialog(true);
        this.m_PanelParams.addParameter("_File", (Component)this.m_PanelFile);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.pack();
    }

    protected String getDefaultTitle() {
        return "Export";
    }

    protected abstract GenericObjectEditorPanel createGOE();

    protected void updateFileChooser() {
        this.m_PanelFile.setDefaultExtension(null);
        this.m_PanelFile.removeChoosableFileFilters();
        this.m_PanelFile.setAcceptAllFileFilterUsed(true);
        this.m_PanelFile.setAutoAppendExtension(false);
        if (this.m_PanelGOE.getCurrent() instanceof FileFormatHandler) {
            FileFormatHandler producer = (FileFormatHandler)this.m_PanelGOE.getCurrent();
            ExtensionFileFilter filter = new ExtensionFileFilter(producer.getFormatDescription(), producer.getFormatExtensions());
            this.m_PanelFile.setDefaultExtension(producer.getDefaultFormatExtension());
            this.m_PanelFile.setAutoAppendExtension(true);
            this.m_PanelFile.addChoosableFileFilter(filter);
            this.m_PanelFile.setFileFilter(filter);
        }
    }

    public void setExport(T value) {
        if (value != null) {
            this.m_PanelGOE.setCurrent((Object)value);
        }
    }

    public T getExport() {
        return (T)this.m_PanelGOE.getCurrent();
    }

    public void setFile(File value) {
        this.m_PanelFile.setCurrent(value);
    }

    public File getFile() {
        return (File)this.m_PanelFile.getCurrent();
    }
}

