/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.io.FilenameProposer;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.FlowReader;
import adams.data.io.output.FlowWriter;
import adams.env.Environment;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.gui.action.AbstractPropertiesAction;
import adams.gui.application.ChildFrame;
import adams.gui.application.ChildWindow;
import adams.gui.chooser.FlowFileChooser;
import adams.gui.core.BaseMenu;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.ToolBarPanel;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.event.TabVisibilityChangeEvent;
import adams.gui.event.TabVisibilityChangeListener;
import adams.gui.event.UndoEvent;
import adams.gui.flow.FlowPanel;
import adams.gui.flow.FlowTabbedPane;
import adams.gui.flow.menu.AbstractFlowEditorMenuItem;
import adams.gui.flow.menu.DebugDisableAllBreakpoints;
import adams.gui.flow.menu.DebugEnableAllBreakpoints;
import adams.gui.flow.menu.DebugRemoveAllBreakpoints;
import adams.gui.flow.menu.DebugStorage;
import adams.gui.flow.menu.DebugVariables;
import adams.gui.flow.menu.EditCheckVariables;
import adams.gui.flow.menu.EditCleanUpFlow;
import adams.gui.flow.menu.EditDiff;
import adams.gui.flow.menu.EditEnableUndo;
import adams.gui.flow.menu.EditFind;
import adams.gui.flow.menu.EditFindNext;
import adams.gui.flow.menu.EditIgnoreNameChanges;
import adams.gui.flow.menu.EditInteractiveActors;
import adams.gui.flow.menu.EditLocateActor;
import adams.gui.flow.menu.EditProcessActors;
import adams.gui.flow.menu.EditRedo;
import adams.gui.flow.menu.EditTimedActors;
import adams.gui.flow.menu.EditUndo;
import adams.gui.flow.menu.ExecutionClearGraphicalOutput;
import adams.gui.flow.menu.ExecutionDisplayErrors;
import adams.gui.flow.menu.ExecutionGC;
import adams.gui.flow.menu.ExecutionHeadless;
import adams.gui.flow.menu.ExecutionKill;
import adams.gui.flow.menu.ExecutionPauseResume;
import adams.gui.flow.menu.ExecutionRun;
import adams.gui.flow.menu.ExecutionStop;
import adams.gui.flow.menu.ExecutionValidateSetup;
import adams.gui.flow.menu.FileCheckOnSave;
import adams.gui.flow.menu.FileClose;
import adams.gui.flow.menu.FileCloseTab;
import adams.gui.flow.menu.FileExport;
import adams.gui.flow.menu.FileImport;
import adams.gui.flow.menu.FileNewFlow;
import adams.gui.flow.menu.FileOpen;
import adams.gui.flow.menu.FileProperties;
import adams.gui.flow.menu.FileRevert;
import adams.gui.flow.menu.FileSave;
import adams.gui.flow.menu.FileSaveAs;
import adams.gui.flow.menu.FlowEditorAction;
import adams.gui.flow.menu.ViewHighlightVariables;
import adams.gui.flow.menu.ViewRedraw;
import adams.gui.flow.menu.ViewRemoveVariableHighlights;
import adams.gui.flow.menu.ViewShowAnnotations;
import adams.gui.flow.menu.ViewShowInputOutput;
import adams.gui.flow.menu.ViewShowQuickInfo;
import adams.gui.flow.menu.ViewShowSource;
import adams.gui.flow.menu.ViewShowToolbar;
import adams.gui.flow.menu.ViewStatistics;
import adams.gui.flow.menu.WindowDuplicateInTab;
import adams.gui.flow.menu.WindowDuplicateInWindow;
import adams.gui.flow.menu.WindowNew;
import adams.gui.flow.tab.FlowTabManager;
import adams.gui.flow.tree.Tree;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FlowEditorPanel
extends ToolBarPanel
implements MenuBarProvider,
StatusMessageHandler,
SendToActionSupporter,
BaseStatusBar.PopupMenuCustomizer {
    private static final long serialVersionUID = -3579084888256133873L;
    public static final String MENU_FILE = "File";
    public static final String MENU_EDIT = "Edit";
    public static final String MENU_DEBUG = "Debug";
    public static final String MENU_EXECUTION = "Execution";
    public static final String MENU_VIEW = "View";
    public static final String MENU_WINDOW = "Window";
    public static final String FILENAME = "FlowEditor.props";
    public static final String FILENAME_MENU = "FlowEditorMenu.props";
    public static final String FILENAME_TREEPOPUPMENU = "FlowEditorTreePopupMenu.props";
    public static final String SESSION_FILE = "FlowSession.props";
    public static final String DEFAULT_TITLE = "Flow editor";
    protected static Properties m_Properties;
    protected static Properties m_PropertiesMenu;
    protected static Properties m_PropertiesTreePopup;
    protected FlowEditorPanel m_Self;
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuFileNew;
    protected FlowEditorAction m_ActionFileLoad;
    protected JMenu m_MenuFileLoadRecent;
    protected FlowEditorAction m_ActionFileNew;
    protected FlowEditorAction m_ActionFileSave;
    protected FlowEditorAction m_ActionFileSaveAs;
    protected FlowEditorAction m_ActionFileCheckOnSave;
    protected FlowEditorAction m_ActionFileRevert;
    protected FlowEditorAction m_ActionFileExport;
    protected FlowEditorAction m_ActionFileImport;
    protected FlowEditorAction m_ActionFileProperties;
    protected FlowEditorAction m_ActionFileCloseTab;
    protected FlowEditorAction m_ActionFileClose;
    protected FlowEditorAction m_ActionEditEnableUndo;
    protected FlowEditorAction m_ActionEditUndo;
    protected FlowEditorAction m_ActionEditRedo;
    protected FlowEditorAction m_ActionEditDiff;
    protected FlowEditorAction m_ActionEditFind;
    protected FlowEditorAction m_ActionEditFindNext;
    protected FlowEditorAction m_ActionEditLocateActor;
    protected FlowEditorAction m_ActionEditCleanUpFlow;
    protected FlowEditorAction m_ActionEditCheckVariables;
    protected FlowEditorAction m_ActionEditInteractiveActors;
    protected FlowEditorAction m_ActionEditTimedActors;
    protected FlowEditorAction m_ActionEditIgnoreNameChanges;
    protected FlowEditorAction m_ActionEditProcessActors;
    protected FlowEditorAction m_ActionDebugEnableAllBreakpoints;
    protected FlowEditorAction m_ActionDebugRemoveAllBreakpoints;
    protected FlowEditorAction m_ActionDebugDisableAllBreakpoints;
    protected FlowEditorAction m_ActionDebugVariables;
    protected FlowEditorAction m_ActionDebugStorage;
    protected FlowEditorAction m_ActionExecutionHeadless;
    protected FlowEditorAction m_ActionExecutionGC;
    protected FlowEditorAction m_ActionExecutionValidateSetup;
    protected FlowEditorAction m_ActionExecutionRun;
    protected FlowEditorAction m_ActionExecutionPauseAndResume;
    protected FlowEditorAction m_MenuItemExecutionPauseAndResume;
    protected FlowEditorAction m_ActionExecutionStop;
    protected FlowEditorAction m_ActionExecutionKill;
    protected FlowEditorAction m_ActionExecutionDisplayErrors;
    protected FlowEditorAction m_ActionExecutionClearGraphicalOutput;
    protected FlowEditorAction m_ActionViewShowToolbar;
    protected FlowEditorAction m_ActionViewShowQuickInfo;
    protected FlowEditorAction m_ActionViewShowAnnotations;
    protected FlowEditorAction m_ActionViewShowInputOutput;
    protected FlowEditorAction m_ActionViewHighlightVariables;
    protected FlowEditorAction m_ActionViewRemoveVariableHighlights;
    protected FlowEditorAction m_ActionViewShowSource;
    protected FlowEditorAction m_ActionViewStatistics;
    protected FlowEditorAction m_ActionViewRedraw;
    protected FlowEditorAction m_ActionNewWindow;
    protected FlowEditorAction m_ActionDuplicateTabInNewWindow;
    protected FlowEditorAction m_ActionDuplicateTab;
    protected List<FlowEditorAction> m_MenuItems;
    protected List<AbstractFlowEditorMenuItem> m_AdditionalMenuItems;
    protected FlowFileChooser m_FileChooser;
    protected BaseStatusBar m_StatusBar;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler;
    protected FilenameProposer m_FilenameProposer;
    protected BaseSplitPane m_SplitPane;
    protected FlowTabbedPane m_FlowPanels;
    protected FlowTabManager m_Tabs;
    protected ToolBarPanel.ToolBarLocation m_PreferredToolBarLocation;

    @Override
    protected void initialize() {
        String[] additionals;
        super.initialize();
        this.m_Self = this;
        this.m_RecentFilesHandler = null;
        this.m_FileChooser = new FlowFileChooser();
        this.m_FileChooser.setMultiSelectionEnabled(true);
        this.m_FileChooser.setCurrentDirectory(new PlaceholderFile(FlowEditorPanel.getPropertiesEditor().getPath("InitialDir", "%h")));
        this.m_FilenameProposer = new FilenameProposer("new", "flow", FlowEditorPanel.getPropertiesEditor().getPath("InitialDir", "%h"));
        this.m_MenuItems = new ArrayList<FlowEditorAction>();
        this.m_AdditionalMenuItems = new ArrayList<AbstractFlowEditorMenuItem>();
        for (String additional : additionals = AbstractFlowEditorMenuItem.getMenuItems()) {
            try {
                AbstractFlowEditorMenuItem item = (AbstractFlowEditorMenuItem)Class.forName(additional).newInstance();
                item.setOwner(this.m_Self);
                this.m_AdditionalMenuItems.add(item);
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate additional menu item '" + additional + "':");
                e.printStackTrace();
            }
        }
        Collections.sort(this.m_AdditionalMenuItems);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = FlowEditorPanel.getPropertiesEditor();
        this.getContentPanel().setLayout(new BorderLayout());
        this.m_PreferredToolBarLocation = ToolBarPanel.ToolBarLocation.valueOf(props.getProperty("ToolBar.Location", "NORTH"));
        if (this.m_PreferredToolBarLocation == ToolBarPanel.ToolBarLocation.HIDDEN) {
            this.m_PreferredToolBarLocation = ToolBarPanel.ToolBarLocation.NORTH;
        }
        this.setToolBarLocation(ToolBarPanel.ToolBarLocation.valueOf(props.getProperty("ToolBar.Location", "NORTH")));
        this.m_SplitPane = new BaseSplitPane(1, true);
        this.m_SplitPane.setDividerLocation(props.getInteger("DividerLocation", 500));
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setResizeWeight(0.5);
        this.getContentPanel().add((Component)this.m_SplitPane, "Center");
        this.m_FlowPanels = new FlowTabbedPane(this);
        if (props.getBoolean("Tabs.ScrollLayout", true).booleanValue()) {
            this.m_FlowPanels.setTabLayoutPolicy(1);
        } else {
            this.m_FlowPanels.setTabLayoutPolicy(0);
        }
        this.m_SplitPane.setLeftComponent(this.m_FlowPanels);
        this.m_Tabs = new FlowTabManager(this);
        this.m_Tabs.addTabVisibilityChangeListener(new TabVisibilityChangeListener(){

            @Override
            public void tabVisibilityChanged(TabVisibilityChangeEvent e) {
                FlowEditorPanel.this.m_SplitPane.setRightComponentHidden(FlowEditorPanel.this.m_Tabs.getTabCount() == 0);
            }
        });
        this.m_SplitPane.setRightComponent(this.m_Tabs);
        this.m_SplitPane.setRightComponentHidden(this.m_Tabs.getTabCount() == 0);
        this.m_StatusBar = new BaseStatusBar();
        this.m_StatusBar.setDialogSize(new Dimension(props.getInteger("StatusBar.Width", 600), props.getInteger("StatusBar.Height", 400)));
        this.m_StatusBar.setMouseListenerActive(true);
        this.m_StatusBar.setPopupMenuCustomizer(this);
        this.m_StatusBar.setStatusProcessor(new BaseStatusBar.StatusProcessor(){

            @Override
            public String process(String msg) {
                return msg.replace(": ", ":\n");
            }
        });
        this.getContentPanel().add((Component)this.m_StatusBar, "South");
    }

    @Override
    protected void initActions() {
        AbstractPropertiesAction action = new FileNewFlow();
        this.m_ActionFileNew = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new FileOpen();
        this.m_ActionFileLoad = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new FileSave();
        this.m_ActionFileSave = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new FileSaveAs();
        this.m_ActionFileSaveAs = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new FileCheckOnSave();
        this.m_ActionFileCheckOnSave = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new FileRevert();
        this.m_ActionFileRevert = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new FileCloseTab();
        this.m_ActionFileCloseTab = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new FileImport();
        this.m_ActionFileImport = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new FileExport();
        this.m_ActionFileExport = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new FileProperties();
        this.m_ActionFileProperties = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new FileClose();
        this.m_ActionFileClose = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new EditEnableUndo();
        this.m_ActionEditEnableUndo = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new EditUndo();
        this.m_ActionEditUndo = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new EditRedo();
        this.m_ActionEditRedo = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new EditDiff();
        this.m_ActionEditDiff = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new EditFind();
        this.m_ActionEditFind = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new EditFindNext();
        this.m_ActionEditFindNext = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new EditLocateActor();
        this.m_ActionEditLocateActor = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new EditCleanUpFlow();
        this.m_ActionEditCleanUpFlow = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new EditCheckVariables();
        this.m_ActionEditCheckVariables = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new EditInteractiveActors();
        this.m_ActionEditInteractiveActors = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new EditTimedActors();
        this.m_ActionEditTimedActors = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new EditIgnoreNameChanges();
        this.m_ActionEditIgnoreNameChanges = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new EditProcessActors();
        this.m_ActionEditProcessActors = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new DebugEnableAllBreakpoints();
        this.m_ActionDebugEnableAllBreakpoints = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new DebugDisableAllBreakpoints();
        this.m_ActionDebugDisableAllBreakpoints = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new DebugRemoveAllBreakpoints();
        this.m_ActionDebugRemoveAllBreakpoints = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new DebugVariables();
        this.m_ActionDebugVariables = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new DebugStorage();
        this.m_ActionDebugStorage = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ExecutionValidateSetup();
        this.m_ActionExecutionValidateSetup = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ExecutionRun();
        this.m_ActionExecutionRun = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ExecutionPauseResume();
        this.m_ActionExecutionPauseAndResume = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ExecutionStop();
        this.m_ActionExecutionStop = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ExecutionKill();
        this.m_ActionExecutionKill = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ExecutionDisplayErrors();
        this.m_ActionExecutionDisplayErrors = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ExecutionClearGraphicalOutput();
        this.m_ActionExecutionClearGraphicalOutput = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ExecutionHeadless();
        this.m_ActionExecutionHeadless = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ExecutionGC();
        this.m_ActionExecutionGC = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ViewShowToolbar();
        this.m_ActionViewShowToolbar = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ViewShowQuickInfo();
        this.m_ActionViewShowQuickInfo = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ViewShowAnnotations();
        this.m_ActionViewShowAnnotations = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ViewShowInputOutput();
        this.m_ActionViewShowInputOutput = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ViewHighlightVariables();
        this.m_ActionViewHighlightVariables = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ViewRemoveVariableHighlights();
        this.m_ActionViewRemoveVariableHighlights = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ViewShowSource();
        this.m_ActionViewShowSource = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ViewStatistics();
        this.m_ActionViewStatistics = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new ViewRedraw();
        this.m_ActionViewRedraw = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new WindowNew();
        this.m_ActionNewWindow = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new WindowDuplicateInWindow();
        this.m_ActionDuplicateTabInNewWindow = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
        action = new WindowDuplicateInTab();
        this.m_ActionDuplicateTab = action;
        this.m_MenuItems.add((FlowEditorAction)((Object)action));
    }

    @Override
    protected void initToolBar() {
        this.addToToolBar(this.m_ActionFileNew);
        this.addToToolBar(this.m_ActionFileLoad);
        this.addToToolBar(this.m_ActionFileSave);
        this.addSeparator();
        this.addToToolBar(this.m_ActionEditUndo);
        this.addToToolBar(this.m_ActionEditRedo);
        this.addSeparator();
        this.addToToolBar(this.m_ActionEditFind);
        this.addSeparator();
        this.addToToolBar(this.m_ActionExecutionValidateSetup);
        this.addToToolBar(this.m_ActionExecutionRun);
        this.addToToolBar(this.m_ActionExecutionPauseAndResume);
        this.addToToolBar(this.m_ActionExecutionStop);
    }

    protected void addAdditionalMenuitems() {
        HashSet<String> separatorAdded = new HashSet<String>();
        for (AbstractFlowEditorMenuItem item : this.m_AdditionalMenuItems) {
            int i;
            JMenu menu = null;
            for (i = 0; i < this.m_MenuBar.getMenuCount(); ++i) {
                if (!this.m_MenuBar.getMenu(i).getText().equals(item.getMenu())) continue;
                menu = this.m_MenuBar.getMenu(i);
                break;
            }
            if (menu == null) {
                menu = new JMenu(item.getMenu());
                for (i = 0; i < this.m_MenuBar.getMenuCount(); ++i) {
                    if (!this.m_MenuBar.getMenu(i).getText().equals(MENU_VIEW)) continue;
                    this.m_MenuBar.add((Component)menu, i + 1);
                }
            }
            int index = menu.getItemCount();
            if (menu.getItemCount() > 0) {
                if (item.getMenu().equals(MENU_FILE)) {
                    index -= 2;
                }
                if (menu.getItem(index - 1) != null && !separatorAdded.contains(item.getMenu())) {
                    separatorAdded.add(item.getMenu());
                    menu.insertSeparator(index);
                    ++index;
                }
            }
            menu.insert(item.getAction(), index);
        }
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            String prefix;
            int i;
            if (this.getParentFrame() != null) {
                JFrame frame = (JFrame)this.getParentFrame();
                frame.setDefaultCloseOperation(0);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        FlowEditorPanel.this.close();
                    }
                });
            } else if (this.getParentDialog() != null) {
                JDialog dialog = (JDialog)this.getParentDialog();
                dialog.setDefaultCloseOperation(0);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        FlowEditorPanel.this.close();
                    }
                });
            }
            result = new JMenuBar();
            BaseMenu menu = new BaseMenu(MENU_FILE);
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FlowEditorPanel.this.updateActions();
                }
            });
            JMenu submenu = new JMenu("New");
            menu.add(submenu);
            submenu.setMnemonic('N');
            submenu.setIcon(GUIHelper.getIcon("new.gif"));
            this.m_MenuFileNew = submenu;
            String[] actors = FlowEditorPanel.getPropertiesEditor().getProperty("NewList", Flow.class.getName()).replace(" ", "").split(",");
            Vector<String> prefixes = new Vector<String>();
            for (i = 0; i < actors.length; ++i) {
                prefix = actors[i].substring(0, actors[i].lastIndexOf(46));
                if (prefixes.contains(prefix)) continue;
                prefixes.add(prefix);
            }
            String prefixPrev = "";
            for (i = 0; i < actors.length; ++i) {
                JMenuItem menuitem;
                final AbstractActor actor = AbstractActor.forName(actors[i], new String[0]);
                prefix = actors[i].substring(0, actors[i].lastIndexOf(46));
                if (!prefix.equals(prefixPrev)) {
                    menuitem = new JMenuItem(prefix);
                    menuitem.setEnabled(false);
                    if (prefixPrev.length() > 0) {
                        submenu.addSeparator();
                    }
                    submenu.add(menuitem);
                    prefixPrev = prefix;
                }
                if (actor instanceof Flow) {
                    submenu.add(this.m_ActionFileNew);
                    continue;
                }
                menuitem = new JMenuItem(actors[i].replaceAll(".*\\.", ""));
                submenu.add(menuitem);
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FlowEditorPanel.this.newFlow(actor);
                    }
                });
            }
            menu.add(this.m_ActionFileLoad);
            submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler<JMenu>(SESSION_FILE, FlowEditorPanel.getPropertiesEditor().getInteger("MaxRecentFlows", 5), submenu);
            this.m_RecentFilesHandler.addRecentItemListener(new RecentItemListener<JMenu, File>(){

                @Override
                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                @Override
                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    FlowPanel panel = FlowEditorPanel.this.m_FlowPanels.newPanel();
                    panel.load(FlowEditorPanel.this.m_FileChooser.getReaderForFile(e.getItem()), e.getItem());
                }
            });
            this.m_MenuFileLoadRecent = submenu;
            menu.add(this.m_ActionFileSave);
            menu.add(this.m_ActionFileSaveAs);
            menu.add(this.m_ActionFileCheckOnSave);
            menu.add(this.m_ActionFileRevert);
            menu.add(this.m_ActionFileCloseTab);
            menu.addSeparator();
            menu.add(this.m_ActionFileImport);
            menu.add(this.m_ActionFileExport);
            SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu);
            menu.addSeparator();
            menu.add(this.m_ActionFileProperties);
            menu.addSeparator();
            menu.add(this.m_ActionFileClose);
            menu = new BaseMenu(MENU_EDIT);
            result.add(menu);
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FlowEditorPanel.this.updateActions();
                }
            });
            menu.add(this.m_ActionEditEnableUndo);
            menu.add(this.m_ActionEditUndo);
            menu.add(this.m_ActionEditRedo);
            menu.add(this.m_ActionEditDiff);
            menu.addSeparator();
            menu.add(this.m_ActionEditFind);
            menu.add(this.m_ActionEditFindNext);
            menu.add(this.m_ActionEditLocateActor);
            menu.addSeparator();
            menu.add(this.m_ActionEditCleanUpFlow);
            menu.add(this.m_ActionEditCheckVariables);
            menu.add(this.m_ActionEditInteractiveActors);
            menu.add(this.m_ActionEditTimedActors);
            menu.add(this.m_ActionEditIgnoreNameChanges);
            menu.addSeparator();
            menu.add(this.m_ActionEditProcessActors);
            menu = new BaseMenu(MENU_DEBUG);
            result.add(menu);
            menu.setMnemonic('D');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FlowEditorPanel.this.updateActions();
                }
            });
            menu.add(this.m_ActionDebugEnableAllBreakpoints);
            menu.add(this.m_ActionDebugDisableAllBreakpoints);
            menu.add(this.m_ActionDebugRemoveAllBreakpoints);
            menu.add(this.m_ActionDebugVariables);
            menu.add(this.m_ActionDebugStorage);
            menu = new BaseMenu(MENU_EXECUTION);
            result.add(menu);
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FlowEditorPanel.this.updateActions();
                }
            });
            menu.add(this.m_ActionExecutionValidateSetup);
            menu.add(this.m_ActionExecutionRun);
            menu.add(this.m_ActionExecutionPauseAndResume);
            menu.add(this.m_ActionExecutionStop);
            menu.add(this.m_ActionExecutionKill);
            menu.addSeparator();
            menu.add(this.m_ActionExecutionDisplayErrors);
            menu.add(this.m_ActionExecutionClearGraphicalOutput);
            menu.addSeparator();
            menu.add(this.m_ActionExecutionHeadless);
            menu.add(this.m_ActionExecutionGC);
            menu = new BaseMenu(MENU_VIEW);
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FlowEditorPanel.this.updateActions();
                }
            });
            menu.add(this.m_ActionViewShowToolbar);
            menu.add(this.m_ActionViewShowQuickInfo);
            menu.add(this.m_ActionViewShowAnnotations);
            menu.add(this.m_ActionViewShowInputOutput);
            this.m_Tabs.addTabsSubmenu(menu);
            menu.addSeparator();
            menu.add(this.m_ActionViewHighlightVariables);
            menu.add(this.m_ActionViewRemoveVariableHighlights);
            menu.add(this.m_ActionViewRedraw);
            menu.addSeparator();
            menu.add(this.m_ActionViewShowSource);
            menu.add(this.m_ActionViewStatistics);
            if (GUIHelper.getParent(this.m_Self, ChildFrame.class) != null && this.getParentDialog() == null) {
                menu = new BaseMenu(MENU_WINDOW);
                result.add(menu);
                menu.setMnemonic('W');
                menu.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        FlowEditorPanel.this.updateActions();
                    }
                });
                menu.add(this.m_ActionNewWindow);
                menu.add(this.m_ActionDuplicateTabInNewWindow);
                menu.add(this.m_ActionDuplicateTab);
            }
            this.m_MenuBar = result;
            this.addAdditionalMenuitems();
            this.updateActions();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public FlowTabManager getTabs() {
        return this.m_Tabs;
    }

    public FlowTabbedPane getFlowPanels() {
        return this.m_FlowPanels;
    }

    @Override
    public void updateActions() {
        for (FlowEditorAction action : this.m_MenuItems) {
            action.update(this.m_Self);
        }
        for (AbstractFlowEditorMenuItem item : this.m_AdditionalMenuItems) {
            item.updateAction();
        }
    }

    protected void updateWidgets() {
        boolean inputEnabled;
        boolean bl = inputEnabled = !this.isRunning() && !this.isStopping();
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().getTree().setEditable(inputEnabled);
        }
    }

    public void update() {
        this.updateActions();
        this.updateWidgets();
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().updateTitle();
        }
    }

    protected boolean checkForModified() {
        boolean result;
        if (!this.hasCurrentPanel()) {
            return true;
        }
        boolean bl = result = !this.getCurrentPanel().isModified();
        if (!result) {
            String msg = this.getCurrentPanel().getCurrentFile() == null ? "Flow not saved - save?" : "Flow not saved - save?\n" + this.getCurrentPanel().getCurrentFile();
            int retVal = GUIHelper.showConfirmMessage(this, msg, "Flow not saved");
            switch (retVal) {
                case 0: {
                    if (this.getCurrentPanel().getCurrentFile() != null) {
                        this.save();
                    } else {
                        this.saveAs();
                    }
                    result = !this.getCurrentPanel().isModified();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    public FlowFileChooser getFileChooser() {
        return this.m_FileChooser;
    }

    protected void newFlow(AbstractActor actor) {
        FlowPanel panel = this.m_FlowPanels.newPanel();
        panel.reset(actor);
        this.updateActions();
        this.updateWidgets();
        this.grabFocus();
    }

    public void setCurrentFile(File value) {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().setCurrentFile(value);
        }
    }

    public File getCurrentFile() {
        if (this.hasCurrentPanel()) {
            return this.getCurrentPanel().getCurrentFile();
        }
        return null;
    }

    public void loadUnsafe(File file) {
        FlowPanel panel = this.m_FlowPanels.newPanel();
        if (!file.exists()) {
            panel.reset(new Flow());
            panel.setCurrentFile(new File(file.getAbsolutePath()));
            this.updateActions();
        } else {
            panel.load(this.m_FileChooser.getReaderForFile(file), file);
        }
    }

    public void setCurrentFlow(AbstractActor flow) {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().setCurrentFlow(flow);
        }
    }

    public boolean hasCurrentPanel() {
        return this.m_FlowPanels.hasCurrentPanel();
    }

    public FlowPanel getCurrentPanel() {
        return this.m_FlowPanels.getCurrentPanel();
    }

    public AbstractActor getCurrentRoot() {
        if (this.hasCurrentPanel()) {
            return this.getCurrentPanel().getCurrentRoot();
        }
        return null;
    }

    public AbstractActor getCurrentFlow() {
        return this.getCurrentFlow(null);
    }

    public AbstractActor getCurrentFlow(StringBuilder errors) {
        if (this.hasCurrentPanel()) {
            return this.getCurrentPanel().getCurrentFlow(errors);
        }
        return null;
    }

    public AbstractActor getRunningFlow() {
        if (this.hasCurrentPanel()) {
            return this.getCurrentPanel().getRunningFlow();
        }
        return null;
    }

    public AbstractActor getLastFlow() {
        if (this.hasCurrentPanel()) {
            return this.getCurrentPanel().getLastFlow();
        }
        return null;
    }

    public void setModified(boolean value) {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().getTree().setModified(value);
        }
        this.update();
    }

    public boolean isModified() {
        return this.hasCurrentPanel() && this.getCurrentPanel().getTree().isModified();
    }

    public void newTab() {
        this.m_FlowPanels.newPanel();
    }

    public void open() {
        int retVal = this.m_FileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        for (PlaceholderFile file : this.m_FileChooser.getSelectedPlaceholderFiles()) {
            FlowPanel panel = this.m_FlowPanels.newPanel();
            panel.load((FlowReader)this.m_FileChooser.getReader(), file);
        }
    }

    protected void revert() {
        if (!this.hasCurrentPanel()) {
            return;
        }
        if (!this.checkForModified()) {
            return;
        }
        this.getCurrentPanel().revert();
    }

    public void save() {
        FlowPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        if (panel.getCurrentFile() == null) {
            this.saveAs();
            return;
        }
        panel.save(this.m_FileChooser.getWriterForFile(panel.getCurrentFile()), panel.getCurrentFile());
    }

    public void saveAs() {
        FlowPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        File file = panel.getCurrentFile();
        if (file == null) {
            file = new PlaceholderFile(this.getCurrentDirectory() + File.separator + panel.getTitle() + "." + "flow");
        }
        if (file.exists()) {
            file = this.m_FilenameProposer.propose(file);
        }
        this.m_FileChooser.setSelectedFile(file);
        int retVal = this.m_FileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        file = this.m_FileChooser.getSelectedPlaceholderFile();
        panel.addUndoPoint("Saving undo data...", "Saving as '" + file.getName() + "'");
        this.showStatus("Saving as '" + file + "'...");
        panel.save((FlowWriter)this.m_FileChooser.getWriter(), this.m_FileChooser.getSelectedPlaceholderFile());
    }

    public void run() {
        this.run(true);
    }

    public void run(boolean showNotification) {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().run(showNotification);
        }
    }

    public boolean isRunning() {
        if (this.getCurrentPanel() == null) {
            return false;
        }
        return this.getCurrentPanel().isRunning();
    }

    public boolean isAnyRunning() {
        boolean result = false;
        for (int i = 0; i < this.m_FlowPanels.getPanelCount(); ++i) {
            if (!this.m_FlowPanels.getPanelAt(i).isRunning()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isStopping() {
        if (this.getCurrentPanel() == null) {
            return false;
        }
        return this.getCurrentPanel().isStopping();
    }

    public boolean isAnyStopping() {
        boolean result = false;
        for (int i = 0; i < this.m_FlowPanels.getPanelCount(); ++i) {
            if (!this.m_FlowPanels.getPanelAt(i).isStopping()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isPaused() {
        if (this.getCurrentPanel() == null) {
            return false;
        }
        return this.getCurrentPanel().isPaused();
    }

    public boolean isAnyPaused() {
        boolean result = false;
        for (int i = 0; i < this.m_FlowPanels.getPanelCount(); ++i) {
            if (!this.m_FlowPanels.getPanelAt(i).isPaused()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isSwingWorkerRunning() {
        if (this.getCurrentPanel() == null) {
            return false;
        }
        return this.getCurrentPanel().isSwingWorkerRunning();
    }

    public boolean isAnySwingWorkerRunning() {
        boolean result = false;
        for (int i = 0; i < this.m_FlowPanels.getPanelCount(); ++i) {
            if (!this.m_FlowPanels.getPanelAt(i).isSwingWorkerRunning()) continue;
            result = true;
            break;
        }
        return result;
    }

    public void stop() {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().stop();
        }
    }

    public void kill() {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().kill();
        }
    }

    public void cleanUp() {
        this.m_FlowPanels.cleanUp();
        for (FlowEditorAction action : this.m_MenuItems) {
            action.cleanUp();
        }
    }

    protected void setVisibleAgain() {
        if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(true);
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(true);
        }
    }

    public void close() {
        if (this.isAnyRunning()) {
            GUIHelper.showErrorMessage(this, "Flows are being executed - closing cancelled!");
            this.setVisibleAgain();
            return;
        }
        if (this.isAnyStopping()) {
            GUIHelper.showErrorMessage(this, "Flows are being stopped - closing cancelled!");
            this.setVisibleAgain();
            return;
        }
        if (!this.checkForModified()) {
            this.setVisibleAgain();
            return;
        }
        this.cleanUp();
        if (this.getParentFrame() != null) {
            ((JFrame)this.getParentFrame()).setDefaultCloseOperation(2);
        }
        this.closeParent();
    }

    public FlowEditorPanel newWindow() {
        return this.newWindow(null);
    }

    public FlowEditorPanel newWindow(AbstractActor actor) {
        FlowEditorPanel result = null;
        ChildFrame oldFrame = (ChildFrame)GUIHelper.getParent(this.m_Self, ChildFrame.class);
        if (oldFrame != null) {
            ChildFrame newFrame = oldFrame.getNewWindow();
            newFrame.setVisible(true);
            result = (FlowEditorPanel)newFrame.getContentPane().getComponent(0);
        } else {
            ChildWindow oldWindow = (ChildWindow)GUIHelper.getParent(this.m_Self, ChildWindow.class);
            if (oldWindow != null) {
                ChildWindow newWindow = oldWindow.getNewWindow();
                newWindow.setVisible(true);
                result = (FlowEditorPanel)newWindow.getContentPane().getComponent(0);
            }
        }
        if (result != null) {
            result.setCurrentDirectory(this.getCurrentDirectory());
            if (actor != null) {
                result.setCurrentFlow(actor);
                result.getCurrentPanel().getTree().setModified(true);
            }
            result.update();
        }
        return result;
    }

    protected void showMessage() {
        if (this.m_StatusBar.hasStatus()) {
            this.showMessage(this.m_StatusBar.getStatus(), false);
        }
    }

    protected void showMessage(String msg, boolean isError) {
        String status = msg.replaceAll(": ", ":\n");
        if (isError) {
            GUIHelper.showErrorMessage(this, status, "Error");
        } else {
            GUIHelper.showInformationMessage(this, status, "Status");
        }
    }

    @Override
    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    public void undoOccurred(UndoEvent e) {
        this.updateActions();
    }

    public void setCurrentDirectory(File value) {
        this.m_FileChooser.setCurrentDirectory(value);
        this.m_FilenameProposer.setDirectory(value.getAbsolutePath());
    }

    public File getCurrentDirectory() {
        return this.m_FileChooser.getCurrentDirectory();
    }

    @Override
    public void grabFocus() {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().grabFocus();
        }
    }

    public void refreshTabs() {
        this.m_Tabs.refresh(this.getCurrentTree());
    }

    public Tree getCurrentTree() {
        return this.m_FlowPanels.getCurrentTree();
    }

    public RecentFilesHandler<JMenu> getRecentFilesHandler() {
        return this.m_RecentFilesHandler;
    }

    @Override
    public Class[] getSendToClasses() {
        return new FlowPanel(this.m_FlowPanels).getSendToClasses();
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return this.hasCurrentPanel() && this.getCurrentPanel().hasSendToItem(cls);
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        if (this.hasCurrentPanel()) {
            return this.getCurrentPanel().getSendToItem(cls);
        }
        return null;
    }

    @Override
    public void customizePopupMenu(final BaseStatusBar source, JPopupMenu menu) {
        if (source.getStatus() != null && source.getStatus().length() > 0) {
            JMenuItem menuitem = new JMenuItem("Copy");
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GUIHelper.copyToClipboard(source.getStatus());
                }
            });
            menu.add(menuitem);
        }
    }

    public ToolBarPanel.ToolBarLocation getPreferredToolBarLocation() {
        return this.m_PreferredToolBarLocation;
    }

    public static synchronized Properties getPropertiesEditor() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("flow editor panel");
        }
        return m_Properties;
    }

    public static synchronized Properties getPropertiesMenu() {
        if (m_PropertiesMenu == null) {
            m_PropertiesMenu = Environment.getInstance().read("flow editor panel menu");
        }
        return m_PropertiesMenu;
    }

    public static synchronized Properties getPropertiesTreePopup() {
        if (m_PropertiesTreePopup == null) {
            m_PropertiesTreePopup = Environment.getInstance().read("flow editor tree popup menu");
        }
        return m_PropertiesTreePopup;
    }
}

