/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.gui.core.BasePanel;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.TextPanel;
import adams.gui.flow.FlowPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class FlowPanelNotificationArea
extends BasePanel {
    private static final long serialVersionUID = -6807606526180616742L;
    protected FlowPanel m_Owner;
    protected TextPanel m_TextNotification;
    protected JButton m_ButtonClose;
    protected JButton m_ButtonCopy;
    protected JCheckBox m_CheckBoxConsole;
    protected HashSet<ActionListener> m_CloseListeners;
    protected String m_Notification;
    protected boolean m_IsError;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Owner = null;
        this.m_CloseListeners = new HashSet();
        this.m_Notification = null;
        this.m_IsError = false;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TextNotification = new TextPanel();
        this.m_TextNotification.setUpdateParentTitle(false);
        this.m_TextNotification.setEditable(false);
        this.m_TextNotification.setLineWrap(true);
        this.add((Component)this.m_TextNotification, "Center");
        JPanel panelRight = new JPanel(new BorderLayout());
        panelRight.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)panelRight, "East");
        JPanel panelButtons = new JPanel(new GridLayout(3, 1, 5, 5));
        panelRight.add((Component)panelButtons, "North");
        this.m_ButtonClose = new JButton("Close");
        this.m_ButtonClose.setIcon(GUIHelper.getIcon("delete.gif"));
        this.m_ButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowPanelNotificationArea.this.clearNotification();
                FlowPanelNotificationArea.this.notifyCloseListeners();
            }
        });
        panelButtons.add(this.m_ButtonClose);
        this.m_ButtonCopy = new JButton("Copy");
        this.m_ButtonCopy.setIcon(GUIHelper.getIcon("copy.gif"));
        this.m_ButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIHelper.copyToClipboard(FlowPanelNotificationArea.this.m_TextNotification.getContent());
            }
        });
        panelButtons.add(this.m_ButtonCopy);
        this.m_CheckBoxConsole = new JCheckBox("Console output");
        this.m_CheckBoxConsole.setSelected(false);
        this.m_CheckBoxConsole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowPanelNotificationArea.this.update();
            }
        });
        panelButtons.add(this.m_CheckBoxConsole);
    }

    public void setOwner(FlowPanel value) {
        this.m_Owner = value;
    }

    public FlowPanel getOwner() {
        return this.m_Owner;
    }

    public void addCloseListener(ActionListener l) {
        this.m_CloseListeners.add(l);
    }

    public void removeCloseListener(ActionListener l) {
        this.m_CloseListeners.remove(l);
    }

    protected synchronized void notifyCloseListeners() {
        ActionEvent event = new ActionEvent(this, 1001, "close");
        for (ActionListener l : this.m_CloseListeners) {
            l.actionPerformed(event);
        }
    }

    protected void update() {
        if (this.m_Notification == null) {
            this.m_TextNotification.setContent("");
        } else {
            String msg = this.m_Notification;
            if (this.m_CheckBoxConsole.isSelected()) {
                msg = msg + "\n\n--- Console output ---\n\n" + ConsolePanel.getSingleton().getPanel(ConsolePanel.PanelType.ALL).getContent();
            }
            String[] lines = msg.split("\n");
            this.setPreferredSize(new Dimension(0, Math.min(300, (lines.length + 1) * 20) + 25));
            this.m_TextNotification.setContent(msg);
        }
        if (this.getOwner() != null) {
            if (this.m_Notification == null) {
                this.getOwner().setTabIcon(null);
                this.getOwner().getSplitPane().setBottomComponentHidden(true);
            } else {
                this.getOwner().setTabIcon(this.m_IsError ? "stop.gif" : "validate_blue.png");
                this.getOwner().getSplitPane().setBottomComponentHidden(false);
            }
        }
    }

    public void showNotification(String msg, boolean error) {
        this.m_Notification = msg;
        this.m_IsError = error;
        this.update();
    }

    public void clearNotification() {
        this.m_Notification = null;
        this.m_IsError = false;
        this.update();
    }
}

