/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.core.CleanUpHandler;
import adams.core.Utils;
import adams.flow.control.Storage;
import adams.flow.control.StorageHandler;
import adams.flow.control.StorageName;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.GUIHelper;
import adams.gui.core.SearchPanel;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SortableAndSearchableTableWithButtons;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.visualization.debug.InspectionPanel;
import adams.gui.visualization.debug.objecttree.AbstractObjectPlainTextRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StoragePanel
extends BasePanel
implements CleanUpHandler {
    private static final long serialVersionUID = 8244881694557542183L;
    protected StorageHandler m_Handler;
    protected SortableAndSearchableTableWithButtons m_Table;
    protected TableModel m_TableModel;
    protected JButton m_ButtonInspect;
    protected JCheckBox m_CheckBoxPreview;
    protected BaseDialog m_DialogInspect;
    protected InspectionPanel m_PanelInspect;
    protected SearchPanel m_PanelSearch;
    protected JPanel m_PanelPreview;
    protected BaseTextArea m_TextAreaPreview;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TableModel = new TableModel();
        this.m_Table = new SortableAndSearchableTableWithButtons(this.m_TableModel);
        this.m_Table.setAutoResizeMode(0);
        this.m_Table.setSelectionMode(0);
        this.m_Table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StoragePanel.this.updateButtons();
                StoragePanel.this.updatePreview();
            }
        });
        this.add((Component)this.m_Table, "Center");
        this.m_ButtonInspect = new JButton("Inspect...");
        this.m_ButtonInspect.setMnemonic('I');
        this.m_ButtonInspect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoragePanel.this.inspect();
            }
        });
        this.m_Table.addToButtonsPanel(this.m_ButtonInspect);
        this.m_Table.setDoubleClickButton(this.m_ButtonInspect);
        this.m_CheckBoxPreview = new JCheckBox("Preview");
        this.m_CheckBoxPreview.setSelected(true);
        this.m_CheckBoxPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoragePanel.this.m_PanelPreview.setVisible(!StoragePanel.this.m_PanelPreview.isVisible());
                StoragePanel.this.updatePreview();
            }
        });
        this.m_Table.addToButtonsPanel(this.m_CheckBoxPreview);
        JPanel panelSouth = new JPanel(new BorderLayout());
        this.add((Component)panelSouth, "South");
        this.m_PanelPreview = new JPanel(new BorderLayout());
        panelSouth.add((Component)this.m_PanelPreview, "Center");
        this.m_TextAreaPreview = new BaseTextArea(10, 80);
        this.m_TextAreaPreview.setFont(GUIHelper.getMonospacedFont());
        this.m_PanelPreview.add((Component)new BaseScrollPane(this.m_TextAreaPreview), "Center");
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_PanelSearch.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                ((SortableAndSearchableTable)StoragePanel.this.m_Table.getComponent()).search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        panelSouth.add((Component)this.m_PanelSearch, "South");
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_ButtonInspect.setEnabled(this.m_Table.getSelectedRowCount() == 1);
    }

    protected void updatePreview() {
        if (!this.m_PanelPreview.isVisible()) {
            return;
        }
        if (this.m_Table.getSelectedRowCount() != 1) {
            return;
        }
        Object obj = this.m_TableModel.getObject((String)this.m_Table.getValueAt(this.m_Table.getSelectedRow(), 0), (String)this.m_Table.getValueAt(this.m_Table.getSelectedRow(), 1));
        List<AbstractObjectPlainTextRenderer> renderer = AbstractObjectPlainTextRenderer.getRenderer(obj);
        if (renderer.size() > 0) {
            this.m_TextAreaPreview.setText(renderer.get(0).render(obj));
        } else {
            this.m_TextAreaPreview.setText("" + obj);
        }
    }

    protected void inspect() {
        if (this.m_DialogInspect == null) {
            this.m_PanelInspect = new InspectionPanel();
            this.m_DialogInspect = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
            this.m_DialogInspect.getContentPane().setLayout(new BorderLayout());
            this.m_DialogInspect.getContentPane().add((Component)this.m_PanelInspect, "Center");
            this.m_DialogInspect.setLocationRelativeTo(this);
        }
        this.m_PanelInspect.setCurrent(this.m_TableModel.getObject((String)this.m_Table.getValueAt(this.m_Table.getSelectedRow(), 0), (String)this.m_Table.getValueAt(this.m_Table.getSelectedRow(), 1)));
        this.m_DialogInspect.setSize(800, 600);
        this.m_DialogInspect.setVisible(true);
    }

    public void setHandler(StorageHandler value) {
        this.m_Handler = value;
        this.m_TableModel = new TableModel(value.getStorage());
        this.m_Table.setModel(this.m_TableModel);
        this.m_Table.setOptimalColumnWidth();
        this.updateButtons();
    }

    public StorageHandler getHandler() {
        return this.m_Handler;
    }

    @Override
    public void cleanUp() {
        if (this.m_PanelInspect != null) {
            this.m_PanelInspect.closeParent();
            this.m_PanelInspect = null;
        }
    }

    public static class TableModel
    extends AbstractBaseTableModel {
        private static final long serialVersionUID = 3509104625095997777L;
        protected Storage m_Storage;
        protected String[][] m_Data;

        public TableModel() {
            this(new Storage());
        }

        public TableModel(Storage storage) {
            this.m_Storage = storage;
            this.initialize();
        }

        protected String getClassString(Object obj) {
            Class<?> cls = obj.getClass();
            String result = cls.isArray() ? Utils.classToString(cls) + " (length: " + Array.getLength(obj) + ")" : (obj instanceof Collection ? cls.getName() + " (size: " + ((Collection)obj).size() + ")" : cls.getName());
            return result;
        }

        protected void initialize() {
            String cache;
            int size = this.m_Storage.size();
            Iterator<String> caches = this.m_Storage.caches();
            while (caches.hasNext()) {
                cache = caches.next();
                size += this.m_Storage.size(cache);
            }
            this.m_Data = new String[size][3];
            int index = 0;
            AbstractList keys = new ArrayList<StorageName>(this.m_Storage.keySet());
            Collections.sort(keys);
            for (StorageName key : keys) {
                this.m_Data[index][0] = "";
                this.m_Data[index][1] = key.getValue();
                this.m_Data[index][2] = this.getClassString(this.m_Storage.get(key));
                ++index;
            }
            caches = this.m_Storage.caches();
            while (caches.hasNext()) {
                cache = caches.next();
                keys = new Vector<StorageName>(this.m_Storage.keySet(cache));
                Collections.sort(keys);
                for (StorageName key : keys) {
                    this.m_Data[index][0] = cache;
                    this.m_Data[index][1] = key.getValue();
                    this.m_Data[index][2] = this.getClassString(this.m_Storage.get(cache, key));
                    ++index;
                }
            }
        }

        public Object getObject(String cache, String key) {
            if (cache == null || cache.length() == 0) {
                return this.m_Storage.get(new StorageName(key));
            }
            return this.m_Storage.get(cache, new StorageName(key));
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.m_Data.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.m_Data[rowIndex][columnIndex];
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Cache";
            }
            if (column == 1) {
                return "Name";
            }
            if (column == 2) {
                return "Type";
            }
            throw new IllegalArgumentException("Illegal column index: " + column);
        }
    }
}

