/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandler;
import adams.gui.core.GUIHelper;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.TreeHelper;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItemAction;
import adams.gui.flow.tree.postprocessor.AbstractEditPostProcessor;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;

public class EditActor
extends AbstractTreePopupMenuItemAction {
    private static final long serialVersionUID = 3991575839421394939L;

    @Override
    protected String getTitle() {
        return "Cut";
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(((StateContainer)this.m_State).isSingleSel);
        if (((StateContainer)this.m_State).editable) {
            this.setName("Edit...");
        } else {
            this.setName("Show...");
        }
    }

    protected void editActor(TreePath path) {
        boolean editable;
        if (path == null) {
            return;
        }
        Node currNode = TreeHelper.pathToNode(path);
        ((StateContainer)this.m_State).tree.updateCurrentEditing((Node)currNode.getParent(), currNode);
        AbstractActor actorOld = currNode.getActor().shallowCopy();
        GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog(((StateContainer)this.m_State).tree);
        boolean bl = editable = ((StateContainer)this.m_State).tree.isEditable() && currNode.isEditable();
        if (editable) {
            dialog.setTitle("Edit...");
        } else {
            dialog.setTitle("Show...");
        }
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        dialog.getGOEEditor().setClassType(AbstractActor.class);
        dialog.setProposedClasses((Class[])null);
        dialog.setCurrent(currNode.getActor().shallowCopy());
        dialog.getGOEEditor().setReadOnly(!editable);
        dialog.getGOEEditor().setFilter(((StateContainer)this.m_State).tree.configureFilter(path, null));
        dialog.setLocationRelativeTo(GUIHelper.getParentComponent(((StateContainer)this.m_State).tree));
        dialog.setVisible(true);
        ((StateContainer)this.m_State).tree.updateCurrentEditing(null, null);
        if (dialog.getResult() == 0) {
            boolean changed;
            AbstractActor actor = (AbstractActor)dialog.getEditor().getValue();
            if (actor.getName().length() == 0) {
                actor.setName(actor.getDefaultName());
            }
            if (actor.equals(actorOld)) {
                actorOld.destroy();
                return;
            }
            Node parent = (Node)currNode.getParent();
            if (!((StateContainer)this.m_State).tree.checkForStandalones(actor, parent)) {
                return;
            }
            this.addUndoPoint("Updating node '" + currNode.getFullName() + "'");
            boolean bl2 = changed = actor.getClass() != actorOld.getClass();
            if (!changed && actor instanceof ActorHandler) {
                ActorHandler handler = (ActorHandler)((Object)actor);
                ActorHandler handlerOld = (ActorHandler)((Object)actorOld);
                boolean bl3 = changed = handler.size() != handlerOld.size();
                if (!changed) {
                    for (int i = 0; i < handler.size(); ++i) {
                        if (handler.get(i).getClass() == handlerOld.get(i).getClass()) continue;
                        changed = true;
                        break;
                    }
                }
            }
            if (changed) {
                if (parent == null) {
                    ((StateContainer)this.m_State).tree.buildTree(actor);
                    currNode = (Node)((StateContainer)this.m_State).tree.getModel().getRoot();
                } else {
                    Node newNode = ((StateContainer)this.m_State).tree.buildTree(null, actor, false);
                    int index = parent.getIndex(currNode);
                    parent.remove(index);
                    parent.insert(newNode, index);
                    currNode = newNode;
                }
            } else {
                currNode.setActor(actor);
            }
            ((StateContainer)this.m_State).tree.updateActorName(currNode);
            ((StateContainer)this.m_State).tree.setModified(true);
            ((StateContainer)this.m_State).tree.nodeStructureChanged(currNode);
            ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, currNode, ActorChangeEvent.Type.MODIFY));
            ((StateContainer)this.m_State).tree.locateAndDisplay(currNode.getFullName());
            ((StateContainer)this.m_State).tree.refreshTabs();
            if (!((StateContainer)this.m_State).tree.getIgnoreNameChanges()) {
                AbstractEditPostProcessor.apply(((StateContainer)this.m_State).tree, parent != null ? parent.getActor() : null, actorOld, currNode.getActor());
            }
        }
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        this.editActor(((StateContainer)this.m_State).selPath);
    }
}

