/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorWithTimedEquivalent;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.GUIHelper;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.TreeHelper;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItemAction;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;

public class MakeTimed
extends AbstractTreePopupMenuItemAction {
    private static final long serialVersionUID = 3991575839421394939L;

    @Override
    protected String getTitle() {
        return "Make timed...";
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(((StateContainer)this.m_State).editable && ((StateContainer)this.m_State).isSingleSel && ((StateContainer)this.m_State).tree.getOwner() != null && ((StateContainer)this.m_State).selNode.getActor() instanceof ActorWithTimedEquivalent);
    }

    protected void makeTimed(TreePath path) {
        Node currNode = TreeHelper.pathToNode(path);
        Node parentNode = (Node)currNode.getParent();
        boolean expanded = ((StateContainer)this.m_State).tree.isExpanded(path);
        AbstractActor currActor = currNode.getFullActor().shallowCopy();
        boolean noEquiv = false;
        Class timedEquiv = null;
        if (!(currActor instanceof ActorWithTimedEquivalent)) {
            noEquiv = true;
        }
        if (!noEquiv && (timedEquiv = ((ActorWithTimedEquivalent)((Object)currActor)).getTimedEquivalent()) == null) {
            noEquiv = true;
        }
        if (noEquiv) {
            GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, "Actor '" + currActor.getClass().getName() + "' does not have a timed equivalent!");
            return;
        }
        Node newNode = null;
        AbstractActor newActor = null;
        try {
            newActor = (AbstractActor)timedEquiv.newInstance();
            newActor.setAnnotations(currActor.getAnnotations());
            newActor.setSkip(currActor.getSkip());
            newActor.setLoggingLevel(currActor.getLoggingLevel());
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, "Failed to instantiate timed equivalent: " + timedEquiv.getName());
            return;
        }
        newNode = new Node(((StateContainer)this.m_State).tree, newActor);
        this.addUndoPoint("Making timed actor from '" + currNode.getActor().getFullName());
        for (BaseTreeNode child : currNode.getChildren()) {
            newNode.add(child);
        }
        boolean defaultName = currActor.getName().equals(currActor.getDefaultName());
        int index = parentNode.getIndex(currNode);
        parentNode.insert(newNode, index);
        parentNode.remove(currNode);
        if (!defaultName) {
            newActor.setName(currActor.getName());
            newNode.setActor(newActor);
            ((StateContainer)this.m_State).tree.updateActorName(newNode);
        }
        if (expanded) {
            ((StateContainer)this.m_State).tree.expand(newNode);
        }
        ((StateContainer)this.m_State).tree.setModified(true);
        ((StateContainer)this.m_State).tree.nodeStructureChanged(parentNode);
        ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, parentNode, ActorChangeEvent.Type.MODIFY));
        ((StateContainer)this.m_State).tree.nodeStructureChanged(parentNode);
        ((StateContainer)this.m_State).tree.locateAndDisplay(newNode.getFullName());
        ((StateContainer)this.m_State).tree.redraw();
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        this.makeTimed(((StateContainer)this.m_State).selPath);
    }
}

