/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.ClassLister;
import adams.gui.goe.AdamsEditorsRegistration;
import java.io.Serializable;

public abstract class AbstractEditorRegistration
implements Serializable {
    private static final long serialVersionUID = 4364270584642868600L;

    protected abstract boolean hasRegistered();

    protected abstract boolean doRegister();

    public boolean register() {
        if (this.hasRegistered()) {
            return true;
        }
        return this.doRegister();
    }

    public static String[] getRegistrations() {
        return ClassLister.getSingleton().getClassnames(AbstractEditorRegistration.class);
    }

    public static synchronized void registerEditors() {
        AbstractEditorRegistration registration;
        String[] registrations;
        for (String classname : registrations = AbstractEditorRegistration.getRegistrations()) {
            try {
                registration = (AbstractEditorRegistration)Class.forName(classname).newInstance();
                if (registration instanceof AdamsEditorsRegistration || registration.register()) continue;
                System.err.println("Failed to register editors successfully: " + classname);
            }
            catch (Throwable t) {
                System.err.println("Failed to register editors: " + classname);
                t.printStackTrace();
            }
        }
        registration = new AdamsEditorsRegistration();
        if (!registration.register()) {
            System.err.println("Failed to register ADMAS editors successfully!");
        }
    }
}

