/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.TriState;
import adams.core.option.AbstractOption;
import adams.gui.goe.AbstractBasicTypePropertyEditor;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class TriStateEditor
extends AbstractBasicTypePropertyEditor {
    protected TriState m_Current = TriState.FALSE;

    @Override
    protected JComponent createCustomEditor() {
        TristateCheckBox result = new TristateCheckBox();
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TriState state = TriStateEditor.checkBoxToTriState((TristateCheckBox)e.getSource());
                if (!TriStateEditor.this.getValue().equals(state)) {
                    TriStateEditor.this.setValue(state);
                }
            }
        });
        return result;
    }

    @Override
    public void setValue(Object value) {
        this.m_Current = (TriState)value;
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this.m_Current;
    }

    @Override
    protected Object parse(String text) throws IllegalArgumentException {
        TriState result;
        try {
            if (text.length() == 0) {
                text = "" + TriState.FALSE;
            }
            result = TriState.valueOf((AbstractOption)null, text);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    @Override
    protected void initForDisplay() {
        this.resetChosenOption();
        TriState state = TriStateEditor.checkBoxToTriState((TristateCheckBox)this.m_CustomEditor);
        if (!this.m_Current.equals(state)) {
            TriStateEditor.setCheckBoxState((TristateCheckBox)this.m_CustomEditor, this.m_Current);
        }
    }

    public static TriState checkBoxToTriState(TristateCheckBox checkbox) {
        TriState result;
        switch (checkbox.getState()) {
            case 2: {
                result = TriState.NOT_SET;
                break;
            }
            case 1: {
                result = TriState.TRUE;
                break;
            }
            default: {
                result = TriState.FALSE;
            }
        }
        return result;
    }

    public static void setCheckBoxState(TristateCheckBox checkbox, TriState state) {
        switch (state) {
            case NOT_SET: {
                checkbox.setState(2);
                break;
            }
            case TRUE: {
                checkbox.setState(1);
                break;
            }
            default: {
                checkbox.setState(0);
            }
        }
    }

    public static String toString(AbstractOption option, Object object) {
        return ((TriState)object).toRaw();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return TriState.valueOf(option, str);
    }
}

