/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.Utils;
import adams.core.io.FilenameProposer;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import adams.env.Environment;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.GUIHelper;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.TitleGenerator;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.event.ScriptingInfoEvent;
import adams.gui.event.ScriptingInfoListener;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingCommand;
import adams.gui.scripting.ScriptingCommandCode;
import adams.gui.scripting.ScriptingEngineHandler;
import adams.gui.scripting.ScriptingTextEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

public abstract class AbstractScriptingDialog
extends BaseDialog
implements ScriptingEngineHandler,
ScriptingInfoListener,
StatusMessageHandler,
DatabaseConnectionHandler,
CleanUpHandler {
    private static final long serialVersionUID = -4712521872103092592L;
    public static final String FILENAME = "ScriptingDialog.props";
    public static final String SESSION_FILE = "ScriptingDialogSession.props";
    protected AbstractScriptingDialog m_Self;
    protected TitleGenerator m_TitleGenerator;
    protected BaseFileChooser m_FileChooser;
    protected JMenuBar m_Menu;
    protected JMenuItem m_MenuItemFileNew;
    protected JMenuItem m_MenuItemFileLoad;
    protected JMenu m_MenuItemFileLoadRecent;
    protected JMenuItem m_MenuItemFileSave;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFilePrint;
    protected JMenuItem m_MenuItemFileClose;
    protected JMenuItem m_MenuItemEditUndo;
    protected JMenuItem m_MenuItemEditRedo;
    protected JMenuItem m_MenuItemEditClear;
    protected JMenuItem m_MenuItemEditAppendRecorded;
    protected JMenuItem m_MenuItemScriptStart;
    protected JMenuItem m_MenuItemScriptStop;
    protected JMenuItem m_MenuItemViewWordWrap;
    protected JMenuItem m_MenuItemHelp;
    protected ScriptingTextEditorPanel m_TextScript;
    protected BaseStatusBar m_StatusBar;
    protected File m_CurrentFile;
    protected boolean m_Modified;
    protected Properties m_Properties;
    protected UndoManager m_Undo;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler;
    protected BasePanel m_BasePanel;
    protected FilenameProposer m_FilenameProposer;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    public AbstractScriptingDialog(Dialog owner, BasePanel panel) {
        super(owner, "Scripting", Dialog.ModalityType.MODELESS);
        this.m_BasePanel = panel;
    }

    public AbstractScriptingDialog(Frame owner, BasePanel panel) {
        super(owner, "Scripting", false);
        this.m_BasePanel = panel;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Properties = Environment.getInstance().read("scripting dialog");
        this.m_Self = this;
        this.m_CurrentFile = null;
        this.m_Modified = false;
        this.m_Undo = new UndoManager();
        this.m_RecentFilesHandler = null;
        this.m_TitleGenerator = new TitleGenerator("Scripting", true);
        this.m_FileChooser = new BaseFileChooser();
        this.m_FileChooser.setCurrentDirectory(new File(this.getScriptingEngine().getScriptsHome()));
        this.m_FilenameProposer = new FilenameProposer("script", "", this.getScriptingEngine().getScriptsHome());
        this.setDatabaseConnection(this.getDefaultDatabaseConnection());
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractScriptingDialog.this.close();
            }
        });
        this.m_TextScript = new ScriptingTextEditorPanel();
        this.m_TextScript.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                AbstractScriptingDialog.this.m_Undo.addEdit(e.getEdit());
                AbstractScriptingDialog.this.updateMenu();
            }
        });
        this.m_TextScript.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractScriptingDialog.this.m_Modified = true;
                AbstractScriptingDialog.this.updateMenu();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractScriptingDialog.this.m_Modified = true;
                AbstractScriptingDialog.this.updateMenu();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractScriptingDialog.this.m_Modified = true;
                AbstractScriptingDialog.this.updateMenu();
            }
        });
        this.getContentPane().add((Component)this.m_TextScript, "Center");
        this.m_StatusBar = new BaseStatusBar();
        this.getContentPane().add((Component)this.m_StatusBar, "South");
        this.m_Menu = new JMenuBar();
        this.setJMenuBar(this.m_Menu);
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        menu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractScriptingDialog.this.updateMenu();
            }
        });
        this.m_Menu.add(menu);
        JMenuItem menuitem = new JMenuItem("New", GUIHelper.getIcon("new.gif"));
        menuitem.setMnemonic('N');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed N"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.newScript();
            }
        });
        menu.add(menuitem);
        this.m_MenuItemFileLoad = menuitem;
        menuitem = new JMenuItem("Open...", GUIHelper.getIcon("open.gif"));
        menuitem.setMnemonic('O');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed O"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.load();
            }
        });
        menu.add(menuitem);
        this.m_MenuItemFileLoad = menuitem;
        JMenu submenu = new JMenu("Open recent");
        menu.add(submenu);
        this.m_RecentFilesHandler = new RecentFilesHandler<JMenu>(this.getSessionFile(), this.m_Properties.getInteger("MaxRecentScripts", 5), submenu);
        this.m_RecentFilesHandler.addRecentItemListener(new RecentItemListener<JMenu, File>(){

            @Override
            public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
            }

            @Override
            public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                if (!AbstractScriptingDialog.this.checkForModified()) {
                    return;
                }
                AbstractScriptingDialog.this.load(e.getItem(), true);
            }
        });
        this.m_MenuItemFileLoadRecent = submenu;
        menuitem = new JMenuItem("Save", GUIHelper.getIcon("save.gif"));
        menuitem.setMnemonic('S');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.save();
            }
        });
        menu.add(menuitem);
        this.m_MenuItemFileSave = menuitem;
        menuitem = new JMenuItem("Save as...", GUIHelper.getEmptyIcon());
        menuitem.setMnemonic('S');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl shift pressed S"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.saveAs();
            }
        });
        menu.add(menuitem);
        this.m_MenuItemFileSaveAs = menuitem;
        menuitem = new JMenuItem("Print", GUIHelper.getIcon("print.gif"));
        menuitem.setMnemonic('P');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed P"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.m_TextScript.printText();
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
        this.m_MenuItemFileClose = menuitem;
        menuitem = new JMenuItem("Close", GUIHelper.getEmptyIcon());
        menuitem.setMnemonic('l');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("alt pressed F4"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.close();
                AbstractScriptingDialog.this.setVisible(false);
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
        this.m_MenuItemFileClose = menuitem;
        menu = new JMenu("Edit");
        menu.setMnemonic('E');
        menu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractScriptingDialog.this.updateMenu();
            }
        });
        this.m_Menu.add(menu);
        menuitem = new JMenuItem("Undo");
        menu.add(menuitem);
        menuitem.setMnemonic('U');
        menuitem.setEnabled(this.m_Undo.canUndo());
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Z"));
        menuitem.setIcon(GUIHelper.getIcon("undo.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.m_Undo.undo();
                AbstractScriptingDialog.this.updateMenu();
            }
        });
        this.m_MenuItemEditUndo = menuitem;
        menuitem = new JMenuItem("Redo");
        menu.add(menuitem);
        menuitem.setMnemonic('R');
        menuitem.setEnabled(this.m_Undo.canUndo());
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Y"));
        menuitem.setIcon(GUIHelper.getIcon("redo.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.m_Undo.redo();
                AbstractScriptingDialog.this.updateMenu();
            }
        });
        this.m_MenuItemEditRedo = menuitem;
        menuitem = new JMenuItem("Clear", GUIHelper.getEmptyIcon());
        menuitem.setMnemonic('C');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl shift pressed N"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.clear();
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
        this.m_MenuItemEditClear = menuitem;
        menuitem = new JMenuItem("Append recorded commands", GUIHelper.getIcon("log.gif"));
        menuitem.setMnemonic('R');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("shift pressed INSERT"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.appendRecorded();
            }
        });
        menu.add(menuitem);
        this.m_MenuItemEditAppendRecorded = menuitem;
        menu = new JMenu("Script");
        menu.setMnemonic('S');
        menu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractScriptingDialog.this.updateMenu();
            }
        });
        this.m_Menu.add(menu);
        menuitem = new JMenuItem("Start", GUIHelper.getIcon("run.gif"));
        menuitem.setMnemonic('S');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("F5"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.startExecution();
            }
        });
        menu.add(menuitem);
        this.m_MenuItemScriptStart = menuitem;
        menuitem = new JMenuItem("Stop", GUIHelper.getIcon("stop.gif"));
        menuitem.setMnemonic('o');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed F5"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.stopExecution();
            }
        });
        menu.add(menuitem);
        this.m_MenuItemScriptStop = menuitem;
        menu = new JMenu("View");
        menu.setMnemonic('V');
        menu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractScriptingDialog.this.updateMenu();
            }
        });
        this.m_Menu.add(menu);
        menuitem = new JCheckBoxMenuItem("Word wrap", GUIHelper.getEmptyIcon());
        menuitem.setMnemonic('W');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed W"));
        menuitem.setSelected(this.m_TextScript.getWordWrap());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.setWordWrap(!AbstractScriptingDialog.this.m_TextScript.getWordWrap());
            }
        });
        menu.add(menuitem);
        this.m_MenuItemViewWordWrap = menuitem;
        menu = new JMenu("Help");
        menu.setMnemonic('H');
        menu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractScriptingDialog.this.updateMenu();
            }
        });
        this.m_Menu.add(menu);
        menuitem = new JMenuItem("Commands", GUIHelper.getIcon("help.gif"));
        menuitem.setMnemonic('C');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("F1"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptingDialog.this.help();
            }
        });
        menu.add(menuitem);
        this.m_MenuItemHelp = menuitem;
        this.pack();
        this.setSize(600, 400);
        this.m_MenuItemViewWordWrap.setSelected(true);
        this.showStatus("Idle");
        this.updateMenu();
    }

    public BasePanel getBasePanel() {
        return this.m_BasePanel;
    }

    protected void setWordWrap(boolean wrap) {
        this.m_TextScript.setWordWrap(wrap);
        this.m_TextScript.setCaretPosition(this.m_TextScript.getDocument().getLength());
    }

    public boolean getWordWrap() {
        return this.m_TextScript.getWordWrap();
    }

    protected boolean checkForModified() {
        boolean result;
        boolean bl = result = !this.m_Modified;
        if (!result) {
            String msg = this.m_CurrentFile == null ? "Script not saved - save?" : "Script not saved - save?\n" + this.m_CurrentFile;
            int retVal = GUIHelper.showConfirmMessage(this, msg, "Script not saved");
            switch (retVal) {
                case 0: {
                    if (this.m_CurrentFile != null) {
                        this.save();
                    } else {
                        this.saveAs();
                    }
                    result = !this.m_Modified;
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    protected void newScript() {
        if (!this.checkForModified()) {
            return;
        }
        this.m_TextScript.setContent("");
        this.m_CurrentFile = null;
        this.m_Modified = false;
        this.updateMenu();
    }

    protected void load() {
        if (!this.checkForModified()) {
            return;
        }
        int retVal = this.m_FileChooser.showOpenDialog(this);
        if (retVal == 0) {
            this.load(this.m_FileChooser.getSelectedFile(), true);
        }
    }

    protected boolean load(File file, boolean errorDlg) {
        boolean result;
        List<String> script = AbstractScriptingEngine.load(file);
        boolean bl = result = script != null;
        if (result) {
            this.m_CurrentFile = file;
            if (this.m_RecentFilesHandler != null) {
                this.m_RecentFilesHandler.addRecentItem(file);
            }
            this.m_TextScript.setContent(Utils.flatten(script, "\n"));
            this.m_TextScript.setCaretPosition(0);
            this.m_Modified = false;
            this.updateMenu();
        } else if (errorDlg) {
            GUIHelper.showErrorMessage(this, "Failed to open script '" + file + "'!");
        }
        return result;
    }

    protected void save() {
        if (this.m_CurrentFile == null) {
            this.saveAs();
        } else {
            this.save(this.m_CurrentFile, true);
        }
    }

    protected void saveAs() {
        this.m_FileChooser.setSelectedFile(this.m_FilenameProposer.propose(this.m_CurrentFile));
        int retVal = this.m_FileChooser.showSaveDialog(this);
        if (retVal == 0) {
            this.save(this.m_FileChooser.getSelectedFile(), true);
        }
    }

    protected boolean save(File file, boolean errorDlg) {
        boolean result = AbstractScriptingEngine.save(this.m_TextScript.getContent().split("\n"), file);
        if (!result && errorDlg) {
            GUIHelper.showErrorMessage(this, "Failed to save script '" + file + "'!");
        }
        if (result) {
            if (this.m_RecentFilesHandler != null) {
                this.m_RecentFilesHandler.addRecentItem(file);
            }
            this.m_CurrentFile = file;
            this.m_Modified = false;
        }
        this.updateMenu();
        return result;
    }

    protected void close() {
        if (!this.checkForModified()) {
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    protected void help() {
        final JDialog dialog = new JDialog(this, "Help on scripting", false);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.setDefaultCloseOperation(2);
        JTextArea textHelp = new JTextArea(30, 80);
        textHelp.setText(this.getScriptingEngine().getProcessor().globalInfo());
        textHelp.setFont(new Font("Monospaced", 0, 12));
        textHelp.setCaretPosition(0);
        textHelp.setEditable(false);
        dialog.getContentPane().add((Component)new BaseScrollPane(textHelp), "Center");
        JButton buttonClose = new JButton("Close", GUIHelper.getIcon("exit.png"));
        buttonClose.setMnemonic('l');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        JPanel panel = new JPanel(new FlowLayout(2));
        panel.add(buttonClose);
        dialog.getContentPane().add((Component)panel, "South");
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    protected void startExecution() {
        this.m_MenuItemFileLoad.setEnabled(false);
        this.m_MenuItemFileLoadRecent.setEnabled(false);
        this.m_MenuItemFileSave.setEnabled(false);
        this.m_MenuItemFileClose.setEnabled(false);
        this.m_MenuItemEditClear.setEnabled(false);
        this.m_MenuItemEditAppendRecorded.setEnabled(false);
        this.m_MenuItemScriptStart.setEnabled(false);
        this.m_MenuItemHelp.setEnabled(false);
        this.m_TextScript.setEnabled(false);
        String[] commands = AbstractScriptingEngine.filter(this.m_TextScript.getContent().split("\n"));
        for (int i = 0; i < commands.length; ++i) {
            if (i < commands.length - 1) {
                this.getScriptingEngine().add(new ScriptingCommand(this.getBasePanel(), commands[i]));
                continue;
            }
            this.getScriptingEngine().add(new ScriptingCommand(this.getBasePanel(), commands[i], new ScriptingCommandCode(){

                @Override
                public void execute() {
                    AbstractScriptingDialog.this.m_TextScript.setEnabled(true);
                    AbstractScriptingDialog.this.showStatus("");
                    AbstractScriptingDialog.this.updateMenu();
                }
            }));
        }
    }

    protected void stopExecution() {
        this.getScriptingEngine().stop();
    }

    protected void appendRecorded() {
        Document doc = this.m_TextScript.getDocument();
        try {
            if (this.m_TextScript.getContent().length() > 0) {
                doc.insertString(doc.getLength(), "\n", null);
            }
            List<String> commands = this.getScriptingEngine().getRecordedCommands();
            for (int i = 0; i < commands.size(); ++i) {
                doc.insertString(doc.getLength(), commands.get(i) + "\n", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void clear() {
        if (!this.checkForModified()) {
            return;
        }
        this.m_TextScript.setContent("");
    }

    protected void updateMenu() {
        boolean running = !this.getScriptingEngine().isEmpty() || this.getScriptingEngine().isProcessing();
        boolean empty = this.m_TextScript.getDocument().getLength() == 0;
        this.m_MenuItemFileLoad.setEnabled(!running);
        this.m_MenuItemFileLoadRecent.setEnabled(!running && this.m_RecentFilesHandler.size() > 0);
        this.m_MenuItemFileSave.setEnabled(!running && this.m_CurrentFile != null && this.m_Modified);
        this.m_MenuItemFileSaveAs.setEnabled(!running && !empty);
        this.m_MenuItemFileClose.setEnabled(!running);
        this.m_MenuItemEditUndo.setEnabled(this.m_Undo.canUndo());
        if (this.m_Undo.canUndo()) {
            this.m_MenuItemEditUndo.setText("Undo - " + this.m_Undo.getUndoPresentationName());
        } else {
            this.m_MenuItemEditUndo.setText("Undo");
        }
        this.m_MenuItemEditRedo.setEnabled(this.m_Undo.canRedo());
        if (this.m_Undo.canRedo()) {
            this.m_MenuItemEditRedo.setText("Redo - " + this.m_Undo.getRedoPresentationName());
        } else {
            this.m_MenuItemEditRedo.setText("Redo");
        }
        this.m_MenuItemEditClear.setEnabled(!running && !empty);
        this.m_MenuItemEditAppendRecorded.setEnabled(!this.getScriptingEngine().isRecording() && this.getScriptingEngine().hasRecording() && !running);
        this.m_MenuItemScriptStart.setEnabled(!empty && !running);
        this.m_MenuItemScriptStop.setEnabled(running);
        this.m_MenuItemViewWordWrap.setEnabled(!running);
        this.m_MenuItemHelp.setEnabled(!running);
        this.updateTitle();
    }

    public TitleGenerator getTitleGenerator() {
        return this.m_TitleGenerator;
    }

    protected void updateTitle() {
        if (!this.m_TitleGenerator.isEnabled()) {
            return;
        }
        this.setTitle(this.m_TitleGenerator.generate(this.m_CurrentFile, this.m_Modified));
    }

    @Override
    public abstract AbstractScriptingEngine getScriptingEngine();

    protected String getSessionFile() {
        return SESSION_FILE;
    }

    @Override
    public void scriptingInfo(ScriptingInfoEvent e) {
        if (!e.hasCmd()) {
            this.showStatus("Idle");
        } else {
            this.showStatus("Running: " + e.getCmd());
        }
        this.updateMenu();
    }

    @Override
    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    @Override
    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        if (this.getScriptingEngine() != null) {
            this.getScriptingEngine().removeScriptingInfoListener(this);
        }
        this.m_DatabaseConnection = value;
        if (this.getScriptingEngine() != null) {
            this.getScriptingEngine().addScriptingInfoListener(this);
        }
    }

    @Override
    public void cleanUp() {
        if (this.getScriptingEngine() != null) {
            this.getScriptingEngine().removeScriptingInfoListener(this);
        }
    }
}

