/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.core.ClassLister;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import java.awt.Graphics;

public abstract class AbstractPaintlet
extends AbstractOptionHandler
implements Paintlet {
    private static final long serialVersionUID = -8877675053270937462L;
    protected transient PaintablePanel m_Panel;
    protected boolean m_Enabled;
    protected boolean m_RepaintOnChange;
    protected boolean m_Initializing;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Panel = null;
        this.m_Initializing = true;
        this.m_Enabled = true;
        this.m_RepaintOnChange = true;
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.m_Initializing = false;
        this.memberChanged();
    }

    protected boolean isInitializing() {
        return this.m_Initializing;
    }

    @Override
    public void setPanel(PaintablePanel value) {
        this.setPanel(value, true);
    }

    @Override
    public void setPanel(PaintablePanel value, boolean register) {
        if (register) {
            if (value != this.m_Panel) {
                if (this.m_Panel != null) {
                    this.m_Panel.removePaintlet(this);
                }
                this.m_Panel = value;
                if (this.m_Panel != null) {
                    this.m_Panel.addPaintlet(this);
                }
                this.memberChanged(true);
            }
        } else {
            this.m_Panel = value;
        }
    }

    @Override
    public PaintablePanel getPanel() {
        return this.m_Panel;
    }

    @Override
    public boolean hasPanel() {
        return this.m_Panel != null;
    }

    @Override
    public PlotPanel getPlot() {
        PlotPanel result = null;
        if (this.m_Panel != null) {
            result = this.m_Panel.getPlot();
        }
        return result;
    }

    @Override
    public void setEnabled(boolean value) {
        this.m_Enabled = value;
        this.repaint();
    }

    @Override
    public boolean isEnabled() {
        return this.m_Enabled;
    }

    @Override
    public void setRepaintOnChange(boolean value) {
        this.m_RepaintOnChange = value;
    }

    @Override
    public boolean getRepaintOnChange() {
        return this.m_RepaintOnChange;
    }

    @Override
    public abstract PaintEvent.PaintMoment getPaintMoment();

    @Override
    public boolean canPaint(PaintEvent.PaintMoment moment) {
        if (this.getPaintMoment() == PaintEvent.PaintMoment.MULTIPLE) {
            return this.isEnabled();
        }
        return this.isEnabled() && this.getPaintMoment() == moment;
    }

    @Override
    public abstract void performPaint(Graphics var1, PaintEvent.PaintMoment var2);

    @Override
    public void paint(Graphics g) {
        if (this.isEnabled() && this.hasPanel()) {
            this.performPaint(g, this.getPaintMoment());
        }
    }

    protected void updatePanel() {
        if (this.hasPanel()) {
            this.getPanel().update();
        }
    }

    public void memberChanged() {
        this.memberChanged(false);
    }

    public void memberChanged(boolean updatePanel) {
        this.reset();
        if (updatePanel) {
            this.updatePanel();
        }
        if (!this.isInitializing() && this.getRepaintOnChange()) {
            this.repaint();
        }
    }

    public void repaint() {
        if (this.isEnabled() && this.hasPanel()) {
            this.m_Panel.update();
        }
    }

    @Override
    public Paintlet shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public Paintlet shallowCopy(boolean expand) {
        return (Paintlet)((Object)OptionUtils.shallowCopy(this, expand));
    }

    public static String[] getPaintlets() {
        return ClassLister.getSingleton().getClassnames(Paintlet.class);
    }

    public static Paintlet forName(String classname, String[] options) {
        Paintlet result;
        try {
            result = (Paintlet)OptionUtils.forName(Paintlet.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static Paintlet forCommandLine(String cmdline) {
        return (Paintlet)((Object)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline));
    }
}

