/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.core.Properties;
import adams.data.io.input.AbstractImageReader;
import adams.gui.core.DragAndDropTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ImageViewerPanel;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.SwingUtilities;

public class ImageTabbedPane
extends DragAndDropTabbedPane {
    private static final long serialVersionUID = 4949565559707097445L;
    protected ImageViewerPanel m_Owner;

    public ImageTabbedPane(ImageViewerPanel owner) {
        this.m_Owner = owner;
    }

    public ImageViewerPanel getOwner() {
        return this.m_Owner;
    }

    public ImagePanel getCurrentPanel() {
        return this.getPanelAt(this.getSelectedIndex());
    }

    public ImagePanel getPanelAt(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return null;
        }
        return (ImagePanel)this.getComponentAt(index);
    }

    public ImagePanel[] getAllPanels() {
        ImagePanel[] result = new ImagePanel[this.getTabCount()];
        for (int i = 0; i < this.getTabCount(); ++i) {
            result[i] = (ImagePanel)this.getComponentAt(i);
        }
        return result;
    }

    public BufferedImage getCurrentImage() {
        return this.getImageAt(this.getSelectedIndex());
    }

    public BufferedImage getImageAt(int index) {
        BufferedImage result = null;
        ImagePanel panel = this.getPanelAt(index);
        if (panel != null) {
            result = panel.getCurrentImage();
        }
        return result;
    }

    public File getCurrentFile() {
        return this.getFileAt(this.getSelectedIndex());
    }

    public File getFileAt(int index) {
        File result = null;
        ImagePanel panel = this.getPanelAt(index);
        if (panel != null) {
            result = panel.getCurrentFile();
        }
        return result;
    }

    protected boolean checkForModified(ImagePanel panel) {
        boolean result;
        if (panel == null) {
            return true;
        }
        boolean bl = result = !panel.isModified();
        if (!result) {
            String msg = panel.getCurrentFile() == null ? "Image not saved - save?" : "Image not saved - save?\n" + panel.getCurrentFile();
            int retVal = GUIHelper.showConfirmMessage(this, msg, "Image not saved");
            switch (retVal) {
                case 0: {
                    this.getOwner().saveAs();
                    result = !panel.isModified();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    @Override
    protected boolean canCloseTabWithMiddleMouseButton(int index) {
        return this.checkForModified((ImagePanel)this.getComponentAt(index));
    }

    public void updateTabTitles() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.updateTabTitle(i);
        }
    }

    public void updateCurrentTabTitle() {
        this.updateTabTitle(this.getSelectedIndex());
    }

    public void updateTabTitle(int index) {
        if (index >= 0) {
            String title = this.getTitleAt(index);
            boolean modified = title.startsWith("*");
            if (modified) {
                title = title.substring(1);
            }
            if (this.getPanelAt(index).isModified() != modified) {
                if (this.getPanelAt(index).isModified()) {
                    title = "*" + title;
                }
                this.setTitleAt(index, title);
            }
        }
    }

    public boolean load(File file) {
        return this.load(file, null);
    }

    public boolean load(File file, AbstractImageReader reader) {
        final ImagePanel panel = new ImagePanel();
        panel.setSelectionEnabled(true);
        if (!panel.load(file, reader)) {
            GUIHelper.showErrorMessage(this, "Failed to open image '" + file + "'!");
            return false;
        }
        Properties props = ImageViewerPanel.getProperties();
        panel.setShowProperties(props.getBoolean("ShowProperties", true));
        panel.setShowLog(props.getBoolean("ShowLog", true));
        panel.getSplitPane().setDividerLocation(props.getInteger("DividerLocation", 500));
        panel.getPropertiesScrollPane().setPreferredSize(new Dimension(props.getInteger("PropertiesWidth", 300), 100));
        this.addTab(file.getName(), panel);
        this.setSelectedComponent(panel);
        final double zoom = props.getDouble("ZoomLevel") / 100.0;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                panel.setScale(zoom);
            }
        };
        SwingUtilities.invokeLater(run);
        return true;
    }
}

