/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.statistics.StatUtils;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.PaintletWithCustomDataSupport;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import gnu.trove.list.array.TDoubleArrayList;
import java.awt.Color;
import java.awt.Graphics;

public class MedianOverlayPaintlet
extends AbstractXYSequencePaintlet
implements PaintletWithCustomDataSupport {
    private static final long serialVersionUID = 6292059403058224856L;

    @Override
    public String globalInfo() {
        return "Draws the median as straight line.";
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.GRID;
    }

    @Override
    public AbstractXYSequencePointHitDetector newHitDetector() {
        return null;
    }

    @Override
    public void drawCustomData(Graphics g, PaintEvent.PaintMoment moment, XYSequence data, Color color) {
        AxisPanel xAxis = this.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel yAxis = this.getPlot().getAxis(Axis.LEFT);
        TDoubleArrayList medianList = new TDoubleArrayList();
        for (XYSequencePoint point : data.toList()) {
            medianList.add(point.getY());
        }
        double median = StatUtils.median(medianList.toArray());
        g.setColor(color);
        g.drawLine(xAxis.valueToPos(xAxis.getActualMinimum()), yAxis.valueToPos(median), xAxis.valueToPos(xAxis.getActualMaximum()), yAxis.valueToPos(median));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        XYSequenceContainerManager xYSequenceContainerManager = this.getActualContainerManager();
        synchronized (xYSequenceContainerManager) {
            for (int i = 0; i < this.getActualContainerManager().count(); ++i) {
                XYSequence data;
                if (!this.getActualContainerManager().isVisible(i) || (data = ((XYSequenceContainer)this.getActualContainerManager().get(i)).getData()).size() == 0) continue;
                XYSequence xYSequence = data;
                synchronized (xYSequence) {
                    this.drawCustomData(g, moment, data, this.getColor(i));
                    continue;
                }
            }
        }
    }
}

