/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequenceUtils;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;

public class StickHitDetector
extends AbstractXYSequencePointHitDetector {
    private static final long serialVersionUID = -6333044496555537078L;

    public StickHitDetector() {
        this(null);
    }

    public StickHitDetector(XYSequencePaintlet owner) {
        super(owner);
    }

    @Override
    protected Object isHit(MouseEvent e) {
        Vector<XYSequencePoint> result = new Vector<XYSequencePoint>();
        AxisPanel axisBottom = this.m_Owner.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisLeft = this.m_Owner.getPlot().getAxis(Axis.LEFT);
        double x = axisBottom.posToValue(e.getX());
        boolean logging = this.isLoggingEnabled();
        for (int i = 0; i < ((XYSequenceContainerManager)this.m_Owner.getSequencePanel().getContainerManager()).count(); ++i) {
            int index;
            if (!((VisibilityContainer)((XYSequenceContainerManager)this.m_Owner.getSequencePanel().getContainerManager()).get(i)).isVisible()) continue;
            XYSequence s = ((XYSequenceContainer)((XYSequenceContainerManager)this.m_Owner.getSequencePanel().getContainerManager()).get(i)).getData();
            List<XYSequencePoint> points = s.toList();
            if (logging) {
                this.getLogger().info("\n" + s.getID() + ":");
            }
            if ((index = XYSequenceUtils.findClosestX(points, x)) == -1) continue;
            XYSequencePoint sp = points.get(index);
            int height = Math.abs(axisLeft.valueToPos(0.0) - axisLeft.valueToPos(sp.getY()));
            int y = sp.getY() > 0.0 ? axisLeft.valueToPos(sp.getY()) : axisLeft.valueToPos(0.0);
            Rectangle rect = new Rectangle(axisBottom.valueToPos(sp.getX()) - this.m_MinimumPixelDifference, y - this.m_MinimumPixelDifference, this.m_MinimumPixelDifference * 2 + 1, height + this.m_MinimumPixelDifference * 2 + 1);
            if (logging) {
                this.getLogger().info("rect: " + rect);
            }
            if (!rect.contains(e.getPoint())) continue;
            if (logging) {
                this.getLogger().info("hit!");
            }
            result.add(sp);
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }
}

