/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.parser.AbstractSymbolEvaluator;
import adams.parser.ParserHelper;
import adams.parser.booleanexpression.Parser;
import adams.parser.booleanexpression.Scanner;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;

public class BooleanExpression
extends AbstractSymbolEvaluator<Boolean> {
    private static final long serialVersionUID = -5923987640355752595L;

    @Override
    public String globalInfo() {
        return "Evaluates boolean expressions.\n\nIt uses the following grammar:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return "expr_list ::= '=' expr_list expr_part | expr_part ;\nexpr_part ::=  expr ;\n\nexpr      ::=   ( expr )\n\n# data types\n              | number\n              | string\n              | boolean\n              | date\n\n# constants\n              | true\n              | false\n              | pi\n              | e\n              | now()\n              | today()\n\n# negating numeric value\n              | -expr\n\n# comparisons\n              | expr < expr\n              | expr <= expr\n              | expr > expr\n              | expr >= expr\n              | expr = expr\n              | expr != expr (or: expr <> expr)\n\n# boolean operations\n              | ! expr (or: not expr)\n              | expr & expr (or: expr and expr)\n              | expr | expr (or: expr or expr)\n              | if[else] ( expr , expr (if true) , expr (if false) )\n              | ifmissing ( variable , expr (default value if variable is missing) )\n              | isNaN ( expr )\n\n# arithmetics\n              | expr + expr\n              | expr - expr\n              | expr * expr\n              | expr / expr\n              | expr ^ expr (power of)\n              | expr % expr (modulo)\n              ;\n\n# numeric functions\n              | abs ( expr )\n              | sqrt ( expr )\n              | cbrt ( expr )\n              | log ( expr )\n              | log10 ( expr )\n              | exp ( expr )\n              | sin ( expr )\n              | sinh ( expr )\n              | cos ( expr )\n              | cosh ( expr )\n              | tan ( expr )\n              | tanh ( expr )\n              | atan ( expr )\n              | atan2 ( exprY , exprX )\n              | hypot ( exprX , exprY )\n              | signum ( expr )\n              | rint ( expr )\n              | floor ( expr )\n              | pow[er] ( expr , expr )\n              | ceil ( expr )\n              | min ( expr1 , expr2 )\n              | max ( expr1 , expr2 )\n              | year ( expr )\n              | month ( expr )\n              | day ( expr )\n              | hour ( expr )\n              | minute ( expr )\n              | second ( expr )\n              | weekday ( expr )\n              | weeknum ( expr )\n\n# string functions\n              | substr ( expr , start [, end] )\n              | left ( expr , len )\n              | mid ( expr , start , len )\n              | right ( expr , len )\n              | rept ( expr , count )\n              | concatenate ( expr1 , expr2 [, expr3-5] )\n              | lower[case] ( expr )\n              | upper[case] ( expr )\n              | trim ( expr )\n              | matches ( expr , regexp )\n              | trim ( expr )\n              | len[gth] ( str )\n              | find ( search , expr [, pos] )\n              | replace ( str , pos , len , newstr )\n              | substitute ( str , find , replace [, occurrences] )\n\n# array functions\n              | len[gth] ( array )\n              | get ( array , index )\n              ;\n\nNotes:\n- Variables are either all upper case letters (e.g., \"ABC\") or any character   apart from \"]\" enclosed by \"[\" and \"]\" (e.g., \"[Hello World]\").\n- 'start' and 'end' for function 'substr' are indices that start at 1.\n- 'index' for function 'get' starts at 1.\n- Index 'end' for function 'substr' is excluded (like Java's 'String.substring(int,int)' method)\n- Line comments start with '#'\n- Semi-colons (';') or commas (',') can be used as separator in the formulas,\n  e.g., 'pow(2,2)' is equivalent to 'pow(2;2)'\n- dates have to be of format 'yyyy-MM-dd' or 'yyyy-MM-dd HH:mm:ss'\n- times have to be of format 'HH:mm:ss' or 'yyyy-MM-dd HH:mm:ss'\n- the characters in square brackets in function names are optional:\n  e.g. 'len(\"abc\")' is the same as 'length(\"abc\")'\n\nA lot of the functions have been modeled after LibreOffice:\n  https://help.libreoffice.org/Calc/Functions_by_Category\n\nAdditional functions:\n" + ParserHelper.getFunctionOverview() + "\n" + "\n" + "Additional procedures:\n" + ParserHelper.getProcedureOverview() + "\n";
    }

    @Override
    protected String getDefaultExpression() {
        return "true";
    }

    @Override
    public String expressionTipText() {
        return "The boolean expression to evaluate (must evaluate to a boolean).";
    }

    @Override
    protected Object initializeSymbol(String name, String value) {
        Double result;
        try {
            result = new Double(value);
        }
        catch (Exception e) {
            result = null;
            this.getLogger().log(Level.SEVERE, "Failed to parse the value of symbol '" + name + "': " + value, e);
        }
        return result;
    }

    @Override
    protected Boolean doEvaluate(HashMap symbols) throws Exception {
        return BooleanExpression.evaluate(this.m_Expression, symbols);
    }

    public static boolean evaluate(String expr, HashMap symbols) throws Exception {
        if (expr.equals("true")) {
            return true;
        }
        if (expr.equals("false")) {
            return false;
        }
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        ByteArrayInputStream parserInput = new ByteArrayInputStream(expr.getBytes());
        Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
        parser.setSymbols(symbols);
        parser.parse();
        return parser.getResult();
    }

    public static HashMap reportToSymbols(Report report) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<AbstractField> fields = report.getFields();
        block4: for (AbstractField field : fields) {
            switch (field.getDataType()) {
                case NUMERIC: {
                    result.put(field.toString(), report.getDoubleValue(field));
                    continue block4;
                }
                case BOOLEAN: {
                    result.put(field.toString(), report.getBooleanValue(field));
                    continue block4;
                }
            }
            result.put(field.toString(), "" + report.getValue(field));
        }
        return result;
    }

    public static boolean evaluate(String expr, Report report) throws Exception {
        return BooleanExpression.evaluate(expr, BooleanExpression.reportToSymbols(report));
    }

    public static void main(String[] args) {
        BooleanExpression.runEvaluator(BooleanExpression.class, args);
    }
}

