/*
 * Decompiled with CFR 0.152.
 */
package moa.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import moa.AbstractMOAObject;
import moa.cluster.Cluster;
import moa.cluster.SphereCluster;
import moa.core.AutoExpandVector;
import moa.gui.visualization.DataPoint;
import weka.core.Attribute;
import weka.core.Instance;

public class Clustering
extends AbstractMOAObject {
    private AutoExpandVector<Cluster> clusters;

    public Clustering() {
        this.clusters = new AutoExpandVector();
    }

    public Clustering(Cluster[] clusters) {
        this.clusters = new AutoExpandVector();
        for (int i = 0; i < clusters.length; ++i) {
            this.clusters.add(clusters[i]);
        }
    }

    public Clustering(List<? extends Instance> points) {
        HashMap<Integer, Integer> labelMap = Clustering.classValues(points);
        int dim = points.get(0).dataset().numAttributes() - 1;
        int numClasses = labelMap.size();
        Attribute classLabel = points.get(0).dataset().classAttribute();
        int lastLabelIndex = classLabel.numValues() - 1;
        int noiseLabel = classLabel.value(lastLabelIndex) == "noise" ? lastLabelIndex : -1;
        ArrayList[] sorted_points = new ArrayList[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            sorted_points[i] = new ArrayList();
        }
        for (Instance instance : points) {
            int clusterid = (int)instance.classValue();
            if (clusterid == noiseLabel) continue;
            sorted_points[labelMap.get(clusterid)].add(instance);
        }
        this.clusters = new AutoExpandVector();
        for (int i = 0; i < numClasses; ++i) {
            if (sorted_points[i].size() <= 0) continue;
            SphereCluster sphereCluster = new SphereCluster(sorted_points[i], dim);
            sphereCluster.setId(((Instance)sorted_points[i].get(0)).classValue());
            sphereCluster.setGroundTruth(((Instance)sorted_points[i].get(0)).classValue());
            this.clusters.add(sphereCluster);
        }
    }

    public Clustering(ArrayList<DataPoint> points, double overlapThreshold, int initMinPoints) {
        HashMap<Integer, Integer> labelMap = Clustering.classValues(points);
        int dim = points.get(0).dataset().numAttributes() - 1;
        int numClasses = labelMap.size();
        int num = 0;
        ArrayList[] sorted_points = new ArrayList[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            sorted_points[i] = new ArrayList();
        }
        for (DataPoint point : points) {
            int clusterid = (int)point.classValue();
            if (clusterid == -1) continue;
            sorted_points[labelMap.get(clusterid)].add(point);
            ++num;
        }
        this.clusters = new AutoExpandVector();
        int microID = 0;
        for (int i = 0; i < numClasses; ++i) {
            int j;
            ArrayList<SphereCluster> microByClass = new ArrayList<SphereCluster>();
            ArrayList pointInCluster = new ArrayList();
            ArrayList pointInMicroClusters = new ArrayList();
            pointInCluster.addAll(sorted_points[i]);
            while (pointInCluster.size() > 0) {
                ArrayList<Instance> micro_points = new ArrayList<Instance>();
                for (j = 0; j < initMinPoints && !pointInCluster.isEmpty(); ++j) {
                    micro_points.add((Instance)pointInCluster.get(0));
                    pointInCluster.remove(0);
                }
                if (micro_points.size() <= 0) continue;
                SphereCluster s = new SphereCluster(micro_points, dim);
                for (int c = 0; c < microByClass.size(); ++c) {
                    if (!(((SphereCluster)microByClass.get(c)).overlapRadiusDegree(s) > overlapThreshold)) continue;
                    micro_points.addAll((Collection)pointInMicroClusters.get(c));
                    s = new SphereCluster(micro_points, dim);
                    pointInMicroClusters.remove(c);
                    microByClass.remove(c);
                }
                for (int j2 = 0; j2 < pointInCluster.size(); ++j2) {
                    Instance instance = (Instance)pointInCluster.get(j2);
                    if (!(s.getInclusionProbability(instance) > 0.8)) continue;
                    pointInCluster.remove(j2);
                    micro_points.add(instance);
                }
                s.setWeight(micro_points.size());
                microByClass.add(s);
                pointInMicroClusters.add(micro_points);
                ++microID;
            }
            boolean changed = true;
            while (changed) {
                changed = false;
                block8: for (int c = 0; c < microByClass.size(); ++c) {
                    for (int c1 = c + 1; c1 < microByClass.size(); ++c1) {
                        double overlap = ((SphereCluster)microByClass.get(c)).overlapRadiusDegree((SphereCluster)microByClass.get(c1));
                        if (!(overlap > overlapThreshold)) continue;
                        ((ArrayList)pointInMicroClusters.get(c)).addAll((Collection)pointInMicroClusters.get(c1));
                        SphereCluster s = new SphereCluster((List)pointInMicroClusters.get(c), dim);
                        microByClass.set(c, s);
                        pointInMicroClusters.remove(c1);
                        microByClass.remove(c1);
                        changed = true;
                        continue block8;
                    }
                }
            }
            for (j = 0; j < microByClass.size(); ++j) {
                ((SphereCluster)microByClass.get(j)).setGroundTruth(((DataPoint)((Object)sorted_points[i].get(0))).classValue());
                this.clusters.add((Cluster)microByClass.get(j));
            }
        }
        for (int j = 0; j < this.clusters.size(); ++j) {
            this.clusters.get(j).setId(j);
        }
    }

    public static HashMap<Integer, Integer> classValues(List<? extends Instance> points) {
        HashMap<Integer, Integer> classes = new HashMap<Integer, Integer>();
        int workcluster = 0;
        boolean hasnoise = false;
        for (int i = 0; i < points.size(); ++i) {
            int label = (int)points.get(i).classValue();
            if (label == -1) {
                hasnoise = true;
                continue;
            }
            if (classes.containsKey(label)) continue;
            classes.put(label, workcluster);
            ++workcluster;
        }
        if (hasnoise) {
            classes.put(-1, workcluster);
        }
        return classes;
    }

    public Clustering(AutoExpandVector<Cluster> clusters) {
        this.clusters = clusters;
    }

    public void add(Cluster cluster) {
        this.clusters.add(cluster);
    }

    public void remove(int index) {
        if (index < this.clusters.size()) {
            this.clusters.remove(index);
        }
    }

    public Cluster get(int index) {
        if (index < this.clusters.size()) {
            return this.clusters.get(index);
        }
        return null;
    }

    public AutoExpandVector<Cluster> getClustering() {
        return this.clusters;
    }

    public AutoExpandVector<Cluster> getClusteringCopy() {
        return (AutoExpandVector)this.clusters.copy();
    }

    public int size() {
        return this.clusters.size();
    }

    public int dimension() {
        assert (this.clusters.size() != 0);
        return this.clusters.get(0).getCenter().length;
    }

    @Override
    public void getDescription(StringBuilder sb, int i) {
        sb.append("Clustering Object");
    }

    public double getMaxInclusionProbability(Instance point) {
        double maxInclusion = 0.0;
        for (int i = 0; i < this.clusters.size(); ++i) {
            maxInclusion = Math.max(this.clusters.get(i).getInclusionProbability(point), maxInclusion);
        }
        return maxInclusion;
    }
}

