/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.evaluation.ClassificationPerformanceEvaluator;
import moa.options.AbstractOptionHandler;
import moa.options.FloatOption;
import moa.tasks.TaskMonitor;
import weka.core.Instance;
import weka.core.Utils;

public class FadingFactorClassificationPerformanceEvaluator
extends AbstractOptionHandler
implements ClassificationPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    protected double TotalweightObserved;
    public FloatOption alphaOption = new FloatOption("alpha", 'a', "Fading factor or exponential smoothing factor", 0.999);
    protected Estimator weightCorrect;

    @Override
    public void reset() {
        this.weightCorrect = new Estimator(this.alphaOption.getValue());
    }

    @Override
    public void addResult(Instance inst, double[] classVotes) {
        double weight = inst.weight();
        int trueClass = (int)inst.classValue();
        if (weight > 0.0) {
            this.TotalweightObserved += weight;
            if (Utils.maxIndex((double[])classVotes) == trueClass) {
                this.weightCorrect.add(1.0);
            } else {
                this.weightCorrect.add(0.0);
            }
        }
    }

    @Override
    public Measurement[] getPerformanceMeasurements() {
        return new Measurement[]{new Measurement("classified instances", this.TotalweightObserved), new Measurement("classifications correct (percent)", this.getFractionCorrectlyClassified() * 100.0)};
    }

    public double getTotalWeightObserved() {
        return this.TotalweightObserved;
    }

    public double getFractionCorrectlyClassified() {
        return this.weightCorrect.estimation();
    }

    public double getFractionIncorrectlyClassified() {
        return 1.0 - this.getFractionCorrectlyClassified();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.reset();
    }

    protected class Estimator {
        protected double alpha;
        protected double estimation;
        protected double b;

        public Estimator(double a) {
            this.alpha = a;
            this.estimation = 0.0;
            this.b = 0.0;
        }

        public void add(double value) {
            this.estimation = this.alpha * this.estimation + value;
            this.b = this.alpha * this.b + 1.0;
        }

        public double estimation() {
            return this.b > 0.0 ? this.estimation / this.b : 0.0;
        }
    }
}

