/*
 * Decompiled with CFR 0.152.
 */
package moa.streams;

import java.util.Random;
import moa.core.InstancesHeader;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;
import weka.core.Instance;

public class ConceptDriftStream
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 1L;
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to add concept drift.", InstanceStream.class, "generators.RandomTreeGenerator");
    public ClassOption driftstreamOption = new ClassOption("driftstream", 'd', "Concept drift Stream.", InstanceStream.class, "generators.RandomTreeGenerator");
    public FloatOption alphaOption = new FloatOption("alpha", 'a', "Angle alpha of change grade.", 0.0, 0.0, 90.0);
    public IntOption positionOption = new IntOption("position", 'p', "Central position of concept drift change.", 0);
    public IntOption widthOption = new IntOption("width", 'w', "Width of concept drift change.", 1000);
    public IntOption randomSeedOption = new IntOption("randomSeed", 'r', "Seed for random noise.", 1);
    protected InstanceStream inputStream;
    protected InstanceStream driftStream;
    protected Random random;
    protected int numberInstanceStream;

    @Override
    public String getPurposeString() {
        return "Adds Concept Drift to examples in a stream.";
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.inputStream = (InstanceStream)this.getPreparedClassOption(this.streamOption);
        this.driftStream = (InstanceStream)this.getPreparedClassOption(this.driftstreamOption);
        this.random = new Random(this.randomSeedOption.getValue());
        this.numberInstanceStream = 0;
        if (this.alphaOption.getValue() != 0.0) {
            this.widthOption.setValue((int)(1.0 / Math.tan(this.alphaOption.getValue() * Math.PI / 180.0)));
        }
    }

    @Override
    public long estimatedRemainingInstances() {
        return this.inputStream.estimatedRemainingInstances() + this.driftStream.estimatedRemainingInstances();
    }

    @Override
    public InstancesHeader getHeader() {
        return this.inputStream.getHeader();
    }

    @Override
    public boolean hasMoreInstances() {
        return this.inputStream.hasMoreInstances() || this.driftStream.hasMoreInstances();
    }

    @Override
    public boolean isRestartable() {
        return this.inputStream.isRestartable() && this.driftStream.isRestartable();
    }

    @Override
    public Instance nextInstance() {
        ++this.numberInstanceStream;
        double x = -4.0 * (double)(this.numberInstanceStream - this.positionOption.getValue()) / (double)this.widthOption.getValue();
        double probabilityDrift = 1.0 / (1.0 + Math.exp(x));
        if (this.random.nextDouble() > probabilityDrift) {
            return this.inputStream.nextInstance();
        }
        return this.driftStream.nextInstance();
    }

    @Override
    public void restart() {
        this.inputStream.restart();
        this.driftStream.restart();
        this.numberInstanceStream = 0;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

