/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import moa.core.ObjectRepository;
import moa.options.FileOption;
import moa.options.FlagOption;
import moa.options.IntOption;
import moa.options.ListOption;
import moa.options.MultiChoiceOption;
import moa.options.StringOption;
import moa.tasks.MainTask;
import moa.tasks.TaskMonitor;

public class Plot
extends MainTask {
    private static final long serialVersionUID = 1L;
    public StringOption gnuplotPathOption = new StringOption("gnuplotPath", 'e', "Directory of the gnuplot executable. For example \"C:\\Tools\\Gnuplot\\binary\".", "");
    public FileOption plotOutputOption = new FileOption("plotOutputFile", 'r', "File with the result plot (image).", null, "eps", true);
    public ListOption inputFilesOption = new ListOption("inputFiles", 'i', "File names or file paths of csv inputs. Values should be seperated by commas.", new StringOption("inputFile", ' ', "Input file.", "algorithm.csv"), new StringOption[]{new StringOption("", ' ', "", "algorithm1.csv"), new StringOption("", ' ', "", "algorithm2.csv"), new StringOption("", ' ', "", "algorithm3.csv")}, ',');
    public ListOption fileAliasesOption = new ListOption("aliases", 'a', "Aliases for files stated in the inputFiles parameter. Aliases will be presented in the plot's legend.", new StringOption("alias", ' ', "File alias.", "MyAlg"), new StringOption[]{new StringOption("", ' ', "", "OZABag"), new StringOption("", ' ', "", "HOT"), new StringOption("", ' ', "", "AWE")}, ',');
    public MultiChoiceOption outputTypeOption = new MultiChoiceOption("outputType", 't', "Gnuplot output terminal.", Terminal.getStringValues(), Terminal.getDescriptions(), 8);
    public MultiChoiceOption plotStyleOption = new MultiChoiceOption("plotStyle", 'p', "Plot style.", PlotStyle.getStringValues(), PlotStyle.getDescriptions(), 2);
    public IntOption xColumnOption = new IntOption("xColumn", 'x', "Index of the csv column from which values for the x-axis should be taken.", 1);
    public StringOption xTitleOption = new StringOption("xTitle", 'm', "Title of the plots' x-axis.", "Processed instances");
    public StringOption xUnitOption = new StringOption("xUnit", 'g', "Units displayed next to x-axis values.", "");
    public IntOption yColumnOption = new IntOption("yColumn", 'y', "Index of the column from which values for the y-axis should be taken", 9);
    public StringOption yTitleOption = new StringOption("yTitle", 'n', "Title of the plots' y-axis.", "Accuracy");
    public StringOption yUnitOption = new StringOption("yUnit", 'u', "Units displayed next to y-axis values.", "%");
    public IntOption lineWidthOption = new IntOption("lineWidth", 'w', "Determines the thickness of plotted lines", 2);
    public IntOption pointIntervalOption = new IntOption("pointInterval", 'v', "Determines the inteval between plotted data points. Used for LINESPOINTS plots only.", 0, 0, Integer.MAX_VALUE);
    public FlagOption smoothOption = new FlagOption("smooth", 's', "Determines whether to smooth the plot with bezier curves.");
    public FlagOption deleteScriptsOption = new FlagOption("deleteScripts", 'd', "Determines whether to delete gnuplot scripts after plotting.");
    public MultiChoiceOption legendLocationOption = new MultiChoiceOption("legendLocation", 'l', "Legend (key) location on the plot.", LegendLocation.getStringValues(), LegendLocation.getDescriptions(), 8);
    public MultiChoiceOption legendTypeOption = new MultiChoiceOption("legendType", 'k', "Legend elements' alignment.", LegendType.getStringValues(), LegendType.getDescriptions(), 1);
    public StringOption additionalSetOption = new StringOption("additionalCommands", 'c', "Additional commands that should be added to the gnuplot script before the plot command. For example \"set tics out\" will change the default tic option and force outward facing tics. See the gnuplot manual for more commands.", " ");
    public StringOption additionalPlotOption = new StringOption("additionalPlotOptions", 'z', "Additional options that should be added to the gnuplot script in the plot statement. For example \"[] [0:]\" will force the y-axis to start from 0. See the gnuplot manual for more options.", " ");

    @Override
    public String getPurposeString() {
        return "Creates a Gnuplot script and plots a chart from a set of given csv files.";
    }

    @Override
    public Class<?> getTaskResultType() {
        return String.class;
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        File resultFile = this.plotOutputOption.getFile();
        if (this.plotOutputOption.getFile() == null) {
            throw new RuntimeException("Plot output file option not set!");
        }
        String resultDirectory = new File(resultFile.getAbsolutePath()).getParent();
        String gnuPlotPath = this.gnuplotPathOption.getValue();
        File gnuplotDir = new File(gnuPlotPath);
        if (!gnuplotDir.exists()) {
            throw new RuntimeException("Gnuplot directory not found: " + gnuPlotPath);
        }
        monitor.setCurrentActivity("Verifying input files...", 0.0);
        if (this.inputFilesOption.getList().length > this.fileAliasesOption.getList().length) {
            throw new RuntimeException("Too little aliases for input files!");
        }
        if (this.inputFilesOption.getList().length < this.fileAliasesOption.getList().length) {
            throw new RuntimeException("Too many aliases for input files!");
        }
        for (int i = 0; i < this.inputFilesOption.getList().length; ++i) {
            File inputFile = new File(((StringOption)this.inputFilesOption.getList()[i]).getValue());
            if (inputFile.exists()) continue;
            throw new RuntimeException("File not found: " + inputFile.getAbsolutePath());
        }
        if (monitor.taskShouldAbort()) {
            return null;
        }
        monitor.setCurrentActivity("Creating script file...", 0.25);
        String gnuplotScriptPath = resultDirectory + File.separator + resultFile.getName() + ".plt";
        String script = this.createScript(resultFile);
        File scriptFile = this.writeScriptToFile(gnuplotScriptPath, script);
        if (monitor.taskShouldAbort()) {
            return null;
        }
        monitor.setCurrentActivity("Plotting data...", 0.5);
        String gnuplotCommand = gnuPlotPath + File.separator + "gnuplot \"" + gnuplotScriptPath + "\"";
        String gnuplotOutput = "";
        try {
            String line;
            Process p = Runtime.getRuntime().exec(gnuplotCommand);
            BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = err.readLine()) != null) {
                gnuplotOutput = gnuplotOutput + line + System.getProperty("line.separator");
            }
            err.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while executing gnuplot script:" + scriptFile, ex);
        }
        if (monitor.taskShouldAbort()) {
            return null;
        }
        if (this.deleteScriptsOption.isSet()) {
            monitor.setCurrentActivity("Deleting script...", 0.75);
            scriptFile.delete();
        }
        if (monitor.taskShouldAbort()) {
            return null;
        }
        monitor.setCurrentActivity("Done", 1.0);
        return resultFile.getAbsolutePath() + System.getProperty("line.separator") + gnuplotOutput;
    }

    private File writeScriptToFile(String gnuplotScriptPath, String script) {
        File scriptFile = new File(gnuplotScriptPath);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(scriptFile));
            writer.write(script);
            writer.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to create or write to script file: " + scriptFile, ex);
        }
        return scriptFile;
    }

    private String createScript(File resultFile) {
        String newLine = System.getProperty("line.separator");
        int sourceFileIdx = 0;
        String script = "set term " + this.terminalOptions(Terminal.valueOf(this.outputTypeOption.getChosenLabel())) + newLine;
        script = script + "set output '" + resultFile.getAbsolutePath() + "'" + newLine;
        script = script + "set datafile separator ','" + newLine;
        script = script + "set grid" + newLine;
        script = script + "set style line 1 pt 8" + newLine;
        script = script + "set style line 2 lt rgb '#00C000'" + newLine;
        script = script + "set style line 5 lt rgb '#FFD800'" + newLine;
        script = script + "set style line 6 lt rgb '#4E0000'" + newLine;
        script = script + "set format x '%.0s %c" + this.getAxisUnit(this.xUnitOption.getValue()) + "'" + newLine;
        script = script + "set format y '%.0s %c" + this.getAxisUnit(this.yUnitOption.getValue()) + "'" + newLine;
        script = script + "set ylabel '" + this.yTitleOption.getValue() + "'" + newLine;
        script = script + "set xlabel '" + this.xTitleOption.getValue() + "'" + newLine;
        if (!this.legendTypeOption.getChosenLabel().equals((Object)LegendType.NONE)) {
            script = script + "set key " + this.legendTypeOption.getChosenLabel().toLowerCase().replace('_', ' ') + " " + this.legendLocationOption.getChosenLabel().toLowerCase().replace('_', ' ') + newLine;
        }
        script = script + this.additionalSetOption.getValue();
        script = script + "plot " + this.additionalPlotOption.getValue() + " ";
        for (int i = 0; i < this.inputFilesOption.getList().length; ++i) {
            if (sourceFileIdx > 0) {
                script = script + ", ";
            }
            ++sourceFileIdx;
            script = script + "'" + ((StringOption)this.inputFilesOption.getList()[i]).getValue() + "' using " + this.xColumnOption.getValue() + ":" + this.yColumnOption.getValue();
            if (this.smoothOption.isSet()) {
                script = script + ":(1.0) smooth bezier";
            }
            script = script + " with " + this.plotStyleOption.getChosenLabel().toLowerCase() + " ls " + sourceFileIdx + " lw " + this.lineWidthOption.getValue();
            if (this.plotStyleOption.getChosenLabel().equals(PlotStyle.LINESPOINTS.toString()) && this.pointIntervalOption.getValue() > 0) {
                script = script + " pointinterval " + this.pointIntervalOption.getValue();
            }
            script = script + " title '" + ((StringOption)this.fileAliasesOption.getList()[i]).getValue() + "'";
        }
        script = script + newLine;
        return script;
    }

    private String getAxisUnit(String unit) {
        if (unit.equals("%")) {
            return "%%";
        }
        return unit;
    }

    private String terminalOptions(Terminal term) {
        String options;
        switch (term) {
            case POSTSCRIPT: {
                options = "postscript enhanced";
                break;
            }
            case POSTSCRIPT_COLOR: {
                options = "postscript color enhanced";
                break;
            }
            default: {
                options = term.toString().toLowerCase();
            }
        }
        return options;
    }

    public static enum PlotStyle {
        LINES,
        POINTS,
        LINESPOINTS,
        IMPULSES,
        STEPS,
        FSTEPS,
        HISTEPS,
        DOTS;

        private static String[] descriptions;

        public static String[] getDescriptions() {
            return descriptions;
        }

        public static String[] getStringValues() {
            int i = 0;
            String[] result = new String[PlotStyle.values().length];
            for (PlotStyle value : PlotStyle.values()) {
                result[i++] = value.name();
            }
            return result;
        }

        static {
            descriptions = new String[]{"It connects each data point with lines. Suitable to smoothly varying data.", "Symbols are shown at the data point location, can be used to plot experimental data.", "Draws lines and symbols at the same time.", "Draw vertical lines from each data point to X-axis. This is a bar-graph without width.", "Histogram type 1", "Histogram type 2", "Histogram type 3", "It displays dots, can be used when there many data points, but hard to see though."};
        }
    }

    public static enum LegendType {
        NONE,
        BOX_VERTICAL,
        BOX_HORIZONTAL,
        NOBOX_VERTICAL,
        NOBOX_HORIZONTAL;


        public static String[] getDescriptions() {
            int i = 0;
            String[] result = new String[LegendType.values().length];
            for (LegendType value : LegendType.values()) {
                result[i++] = value.name().toLowerCase().replace('_', ' ');
            }
            return result;
        }

        public static String[] getStringValues() {
            int i = 0;
            String[] result = new String[LegendType.values().length];
            for (LegendType value : LegendType.values()) {
                result[i++] = value.name();
            }
            return result;
        }
    }

    public static enum LegendLocation {
        TOP_LEFT_INSIDE,
        TOP_CENTER_INSIDE,
        TOP_RIGHT_INSIDE,
        LEFT_INSIDE,
        CENTER_INSIDE,
        RIGHT_INSIDE,
        BOTTOM_LEFT_INSIDE,
        BOTTOM_CENTER_INSIDE,
        BOTTOM_RIGHT_INSIDE,
        TOP_LEFT_OUTSIDE,
        TOP_CENTER_OUTSIDE,
        TOP_RIGHT_OUTSIDE,
        LEFT_OUTSIDE,
        CENTER_OUTSIDE,
        RIGHT_OUTSIDE,
        BOTTOM_LEFT_OUTSIDE,
        BOTTOM_CENTER_OUTSIDE,
        BOTTOM_RIGHT_OUTSIDE;


        public static String[] getDescriptions() {
            int i = 0;
            String[] result = new String[LegendLocation.values().length];
            for (LegendLocation value : LegendLocation.values()) {
                result[i++] = value.name().toLowerCase().replace('_', ' ');
            }
            return result;
        }

        public static String[] getStringValues() {
            int i = 0;
            String[] result = new String[LegendLocation.values().length];
            for (LegendLocation value : LegendLocation.values()) {
                result[i++] = value.name();
            }
            return result;
        }
    }

    public static enum Terminal {
        CANVAS,
        EPSLATEX,
        GIF,
        JPEG,
        LATEX,
        PDFCAIRO,
        PNG,
        POSTSCRIPT,
        POSTSCRIPT_COLOR,
        PSLATEX,
        PSTEX,
        PSTRICKS,
        SVG;

        private static String[] descriptions;

        public static String[] getDescriptions() {
            return descriptions;
        }

        public static String[] getStringValues() {
            int i = 0;
            String[] result = new String[Terminal.values().length];
            for (Terminal value : Terminal.values()) {
                result[i++] = value.name();
            }
            return result;
        }

        static {
            descriptions = new String[]{"HTML Canvas object", "LaTeX picture environment using graphicx package", "GIF images using libgd and TrueType fonts", "JPEG images using libgd and TrueType fonts", "LaTeX picture environment", "pdf terminal based on cairo", "PNG images using libgd and TrueType fonts", "PostScript graphics, including EPSF embedded files (*.eps)", "Color PostScript graphics, including EPSF embedded files (*.eps)", "LaTeX picture environment with PostScript specials", "plain TeX with PostScript specials", "LaTeX picture environment with PSTricks macros", "W3C Scalable Vector Graphics driver"};
        }
    }
}

