/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.BatchBindStep;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Param;
import org.jooq.Query;
import org.jooq.conf.ParamType;
import org.jooq.conf.SettingsTools;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultBindContext;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.Utils;

class BatchSingle
implements BatchBindStep {
    private static final long serialVersionUID = 3793967258181493207L;
    private final DSLContext create;
    private final Configuration configuration;
    private final Query query;
    private final List<Object[]> allBindValues;

    public BatchSingle(Configuration configuration, Query query) {
        this.create = DSL.using(configuration);
        this.configuration = configuration;
        this.query = query;
        this.allBindValues = new ArrayList<Object[]>();
    }

    @Override
    public final BatchSingle bind(Object ... bindValues) {
        this.allBindValues.add(bindValues);
        return this;
    }

    @Override
    public final BatchSingle bind(Object[][] bindValues) {
        for (Object[] v : bindValues) {
            this.bind(v);
        }
        return this;
    }

    @Override
    public final int size() {
        return this.allBindValues.size();
    }

    @Override
    public final int[] execute() {
        if (SettingsTools.executeStaticStatements(this.configuration.settings())) {
            return this.executeStatic();
        }
        return this.executePrepared();
    }

    private final int[] executePrepared() {
        DefaultExecuteContext ctx = new DefaultExecuteContext(this.configuration, new Query[]{this.query});
        ExecuteListeners listener = new ExecuteListeners(ctx);
        Connection connection = ctx.connection();
        ArrayList params = new ArrayList(this.query.getParams().values());
        ArrayList previous = new ArrayList();
        for (Param param : params) {
            previous.add(param.getValue());
        }
        try {
            int i;
            listener.renderStart(ctx);
            ctx.sql(this.create.render(this.query));
            listener.renderEnd(ctx);
            listener.prepareStart(ctx);
            ctx.statement(connection.prepareStatement(ctx.sql()));
            listener.prepareEnd(ctx);
            for (Object[] objectArray : this.allBindValues) {
                listener.bindStart(ctx);
                for (i = 0; i < params.size(); ++i) {
                    ((Param)params.get(i)).setConverted(objectArray[i]);
                }
                Utils.visitAll(new DefaultBindContext(this.configuration, ctx.statement()), params);
                listener.bindEnd(ctx);
                ctx.statement().addBatch();
            }
            listener.executeStart(ctx);
            int[] result = ctx.statement().executeBatch();
            int[] nArray = ctx.batchRows();
            for (i = 0; i < nArray.length && i < result.length; ++i) {
                nArray[i] = result[i];
            }
            listener.executeEnd(ctx);
            int[] nArray2 = result;
            return nArray2;
        }
        catch (SQLException e) {
            ctx.sqlException(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        finally {
            Utils.safeClose(listener, ctx);
            for (int i = 0; i < params.size(); ++i) {
                ((Param)params.get(i)).setConverted(previous.get(i));
            }
        }
    }

    private final int[] executeStatic() {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Object[] bindValues : this.allBindValues) {
            for (int i = 0; i < bindValues.length; ++i) {
                this.query.bind(i + 1, bindValues[i]);
            }
            queries.add(this.create.query(this.query.getSQL(ParamType.INLINED)));
        }
        return this.create.batch(queries).execute();
    }
}

