/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.List;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.tools.LoggerListener;
import org.jooq.tools.StopWatchListener;

class ExecuteListeners
implements ExecuteListener {
    private static final long serialVersionUID = 7399239846062763212L;
    private final List<ExecuteListener> listeners;
    private boolean resultStart;
    private boolean fetchEnd;

    ExecuteListeners(ExecuteContext ctx) {
        this.listeners = ExecuteListeners.listeners(ctx);
        this.start(ctx);
    }

    private static List<ExecuteListener> listeners(ExecuteContext ctx) {
        ArrayList<ExecuteListener> result = new ArrayList<ExecuteListener>();
        if (!Boolean.FALSE.equals(ctx.configuration().settings().isExecuteLogging())) {
            result.add(new LoggerListener());
            result.add(new StopWatchListener());
        }
        for (ExecuteListenerProvider provider : ctx.configuration().executeListenerProviders()) {
            if (provider == null) continue;
            result.add(provider.provide());
        }
        return result;
    }

    @Override
    public final void start(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.start(ctx);
        }
    }

    @Override
    public final void renderStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.renderStart(ctx);
        }
    }

    @Override
    public final void renderEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.renderEnd(ctx);
        }
    }

    @Override
    public final void prepareStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.prepareStart(ctx);
        }
    }

    @Override
    public final void prepareEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.prepareEnd(ctx);
        }
    }

    @Override
    public final void bindStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.bindStart(ctx);
        }
    }

    @Override
    public final void bindEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.bindEnd(ctx);
        }
    }

    @Override
    public final void executeStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.executeStart(ctx);
        }
    }

    @Override
    public final void executeEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.executeEnd(ctx);
        }
    }

    @Override
    public final void fetchStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.fetchStart(ctx);
        }
    }

    @Override
    public final void resultStart(ExecuteContext ctx) {
        this.resultStart = true;
        for (ExecuteListener listener : this.listeners) {
            listener.resultStart(ctx);
        }
    }

    @Override
    public final void recordStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.recordStart(ctx);
        }
    }

    @Override
    public final void recordEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.recordEnd(ctx);
        }
    }

    @Override
    public final void resultEnd(ExecuteContext ctx) {
        this.resultStart = false;
        for (ExecuteListener listener : this.listeners) {
            listener.resultEnd(ctx);
        }
        if (this.fetchEnd) {
            this.fetchEnd(ctx);
        }
    }

    @Override
    public final void fetchEnd(ExecuteContext ctx) {
        if (this.resultStart) {
            this.fetchEnd = true;
        } else {
            for (ExecuteListener listener : this.listeners) {
                listener.fetchEnd(ctx);
            }
        }
    }

    @Override
    public final void end(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.end(ctx);
        }
    }

    @Override
    public final void exception(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.exception(ctx);
        }
    }
}

