/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.RenderContext;
import org.jooq.impl.AbstractQueryPartMap;
import org.jooq.impl.Utils;

class FieldMapForInsert
extends AbstractQueryPartMap<Field<?>, Field<?>> {
    private static final long serialVersionUID = -2192833491610583485L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.FIELD_ROW};

    FieldMapForInsert() {
    }

    @Override
    public final void toSQL(RenderContext context) {
        boolean indent = this.size() > 1;
        context.sql("(");
        if (indent) {
            context.formatIndentStart();
        }
        String separator = "";
        for (Field field : this.values()) {
            context.sql(separator);
            if (indent) {
                context.formatNewLine();
            }
            context.visit(field);
            separator = ", ";
        }
        if (indent) {
            context.formatIndentEnd().formatNewLine();
        }
        context.sql(")");
    }

    final void toSQLReferenceKeys(RenderContext context) {
        boolean indent = this.size() > 1;
        context.sql("(");
        if (indent) {
            context.formatIndentStart();
        }
        boolean qualify = context.qualify();
        context.qualify(false);
        String separator = "";
        for (Field field : this.keySet()) {
            context.sql(separator);
            if (indent) {
                context.formatNewLine();
            }
            context.visit(field);
            separator = ", ";
        }
        context.qualify(qualify);
        if (indent) {
            context.formatIndentEnd().formatNewLine();
        }
        context.sql(")");
    }

    @Override
    public final void bind(BindContext context) {
        Utils.visitAll(context, this.keySet());
        Utils.visitAll(context, this.values());
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    final void putFields(Collection<? extends Field<?>> fields) {
        for (Field<?> field : fields) {
            this.put(field, null);
        }
    }

    final void putValues(Collection<? extends Field<?>> values) {
        if (values.size() != this.size()) {
            throw new IllegalArgumentException("The number of values must match the number of fields: " + this);
        }
        Iterator<Field<?>> it = values.iterator();
        for (Map.Entry entry : this.entrySet()) {
            entry.setValue(it.next());
        }
    }

    final void set(Map<? extends Field<?>, ?> map) {
        for (Map.Entry<Field<?>, ?> entry : map.entrySet()) {
            Field<?> field = entry.getKey();
            Object value = entry.getValue();
            this.put((QueryPart)entry.getKey(), Utils.field(value, field));
        }
    }
}

