/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import org.jooq.AggregateFunction;
import org.jooq.BindContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderedAggregateFunction;
import org.jooq.QueryPart;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.SortField;
import org.jooq.WindowBeforeOverStep;
import org.jooq.WindowFinalStep;
import org.jooq.WindowIgnoreNullsStep;
import org.jooq.WindowOrderByStep;
import org.jooq.WindowPartitionByStep;
import org.jooq.WindowRowsAndStep;
import org.jooq.WindowRowsStep;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.SortFieldList;
import org.jooq.impl.Term;

class Function<T>
extends AbstractField<T>
implements OrderedAggregateFunction<T>,
AggregateFunction<T>,
WindowBeforeOverStep<T>,
WindowIgnoreNullsStep<T>,
WindowPartitionByStep<T>,
WindowRowsStep<T>,
WindowRowsAndStep<T> {
    private static final long serialVersionUID = 347252741712134044L;
    private final Name name;
    private final Term term;
    private final QueryPartList<QueryPart> arguments;
    private final boolean distinct;
    private final SortFieldList withinGroupOrderBy;
    private final SortFieldList keepDenseRankOrderBy;
    private final QueryPartList<Field<?>> partitionBy;
    private final SortFieldList orderBy;
    private boolean first;
    private boolean over;
    private boolean partitionByOne;
    private boolean ignoreNulls;
    private boolean respectNulls;
    private Integer rowsStart;
    private Integer rowsEnd;

    Function(String name, DataType<T> type, QueryPart ... arguments) {
        this(name, false, type, arguments);
    }

    Function(Term term, DataType<T> type, QueryPart ... arguments) {
        this(term, false, type, arguments);
    }

    Function(Name name, DataType<T> type, QueryPart ... arguments) {
        this(name, false, type, arguments);
    }

    Function(String name, boolean distinct, DataType<T> type, QueryPart ... arguments) {
        super(name, type);
        this.term = null;
        this.name = null;
        this.distinct = distinct;
        this.arguments = new QueryPartList(arguments);
        this.keepDenseRankOrderBy = new SortFieldList();
        this.withinGroupOrderBy = new SortFieldList();
        this.partitionBy = new QueryPartList();
        this.orderBy = new SortFieldList();
    }

    Function(Term term, boolean distinct, DataType<T> type, QueryPart ... arguments) {
        super(term.name().toLowerCase(), type);
        this.term = term;
        this.name = null;
        this.distinct = distinct;
        this.arguments = new QueryPartList(arguments);
        this.keepDenseRankOrderBy = new SortFieldList();
        this.withinGroupOrderBy = new SortFieldList();
        this.partitionBy = new QueryPartList();
        this.orderBy = new SortFieldList();
    }

    Function(Name name, boolean distinct, DataType<T> type, QueryPart ... arguments) {
        super(Function.last(name.getName()), type);
        this.term = null;
        this.name = name;
        this.distinct = distinct;
        this.arguments = new QueryPartList(arguments);
        this.keepDenseRankOrderBy = new SortFieldList();
        this.withinGroupOrderBy = new SortFieldList();
        this.partitionBy = new QueryPartList();
        this.orderBy = new SortFieldList();
    }

    private static String last(String ... strings) {
        if (strings != null && strings.length > 0) {
            return strings[strings.length - 1];
        }
        return null;
    }

    @Override
    public final void bind(BindContext context) {
        if (this.term == Term.LIST_AGG && Arrays.asList(SQLDialect.CUBRID, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL).contains((Object)context.configuration().dialect())) {
            context.visit((QueryPart)this.arguments.get(0));
            context.visit(this.withinGroupOrderBy);
            if (this.arguments.size() > 1) {
                context.visit((QueryPart)this.arguments.get(1));
            }
        } else {
            ((BindContext)((BindContext)((BindContext)((BindContext)context.visit(this.arguments)).visit(this.keepDenseRankOrderBy)).visit(this.withinGroupOrderBy)).visit(this.partitionBy)).visit(this.orderBy);
        }
    }

    @Override
    public final void toSQL(RenderContext context) {
        if (this.term == Term.LIST_AGG && Arrays.asList(SQLDialect.CUBRID, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL).contains((Object)context.configuration().dialect())) {
            this.toSQLGroupConcat(context);
        } else if (this.term == Term.LIST_AGG && Arrays.asList(SQLDialect.POSTGRES).contains((Object)context.configuration().dialect())) {
            this.toSQLStringAgg(context);
        } else {
            this.toSQLArguments(context);
            this.toSQLKeepDenseRankOrderByClause(context);
            this.toSQLWithinGroupClause(context);
            this.toSQLOverClause(context);
        }
    }

    private void toSQLStringAgg(RenderContext context) {
        this.toSQLFunctionName(context);
        context.sql("(");
        if (this.distinct) {
            context.keyword("distinct").sql(" ");
        }
        context.visit(((Field)this.arguments.get(0)).cast(String.class));
        if (this.arguments.size() > 1) {
            context.sql(", ");
            context.visit((QueryPart)this.arguments.get(1));
        } else {
            context.sql(", ''");
        }
        if (!this.withinGroupOrderBy.isEmpty()) {
            context.sql(" ").keyword("order by").sql(" ").visit(this.withinGroupOrderBy);
        }
        context.sql(")");
        this.toSQLOverClause(context);
    }

    private final void toSQLGroupConcat(RenderContext context) {
        this.toSQLFunctionName(context);
        context.sql("(");
        if (this.distinct) {
            context.keyword("distinct").sql(" ");
        }
        context.visit((QueryPart)this.arguments.get(0));
        if (!this.withinGroupOrderBy.isEmpty()) {
            context.sql(" ").keyword("order by").sql(" ").visit(this.withinGroupOrderBy);
        }
        if (this.arguments.size() > 1) {
            context.sql(" ").keyword("separator").sql(" ").visit((QueryPart)this.arguments.get(1));
        }
        context.sql(")");
    }

    private final void toSQLOverClause(RenderContext context) {
        if (!this.over) {
            return;
        }
        if (this.over && this.term == Term.ROW_NUMBER && context.configuration().dialect() == SQLDialect.HSQLDB) {
            return;
        }
        String glue = "";
        context.sql(" ").keyword("over").sql(" (");
        if (!(this.partitionBy.isEmpty() || this.partitionByOne && Arrays.asList(SQLDialect.CUBRID).contains((Object)context.configuration().dialect()))) {
            context.sql(glue).keyword("partition by").sql(" ").visit(this.partitionBy);
            glue = " ";
        }
        if (!this.orderBy.isEmpty()) {
            context.sql(glue).keyword("order by").sql(" ").visit(this.orderBy);
            glue = " ";
        }
        if (this.rowsStart != null) {
            context.sql(glue);
            context.keyword("rows").sql(" ");
            if (this.rowsEnd != null) {
                context.keyword("between").sql(" ");
                this.toSQLRows(context, this.rowsStart);
                context.sql(" ").keyword("and").sql(" ");
                this.toSQLRows(context, this.rowsEnd);
            } else {
                this.toSQLRows(context, this.rowsStart);
            }
            glue = " ";
        }
        context.sql(")");
    }

    private void toSQLKeepDenseRankOrderByClause(RenderContext context) {
        if (!this.keepDenseRankOrderBy.isEmpty()) {
            ((RenderContext)context.sql(" ").keyword("keep").sql(" (").keyword("dense_rank").sql(" ").keyword(this.first ? "first" : "last").sql(" ").keyword("order by").sql(" ").visit(this.keepDenseRankOrderBy)).sql(")");
        }
    }

    private final void toSQLWithinGroupClause(RenderContext context) {
        if (!this.withinGroupOrderBy.isEmpty()) {
            ((RenderContext)context.sql(" ").keyword("within group").sql(" (").keyword("order by").sql(" ").visit(this.withinGroupOrderBy)).sql(")");
        }
    }

    private final void toSQLArguments(RenderContext context) {
        this.toSQLFunctionName(context);
        context.sql("(");
        if (this.distinct) {
            context.keyword("distinct").sql(" ");
        }
        if (!this.arguments.isEmpty()) {
            context.visit(this.arguments);
        }
        if (this.ignoreNulls) {
            context.sql(" ").keyword("ignore nulls");
        } else if (this.respectNulls) {
            context.sql(" ").keyword("respect nulls");
        }
        context.sql(")");
    }

    private final void toSQLFunctionName(RenderContext ctx) {
        if (this.name != null) {
            ctx.visit(this.name);
        } else if (this.term != null) {
            ctx.sql(this.term.translate(ctx.configuration().dialect()));
        } else {
            ctx.sql(this.getName());
        }
    }

    private final void toSQLRows(RenderContext context, Integer rows) {
        if (rows == Integer.MIN_VALUE) {
            context.keyword("unbounded preceding");
        } else if (rows == Integer.MAX_VALUE) {
            context.keyword("unbounded following");
        } else if (rows < 0) {
            context.sql(-rows.intValue());
            context.sql(" ").keyword("preceding");
        } else if (rows > 0) {
            context.sql(rows);
            context.sql(" ").keyword("following");
        } else {
            context.keyword("current row");
        }
    }

    final QueryPartList<QueryPart> getArguments() {
        return this.arguments;
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(Field<?> ... fields) {
        this.withinGroupOrderBy.addAll(fields);
        return this;
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(SortField<?> ... fields) {
        this.withinGroupOrderBy.addAll(Arrays.asList(fields));
        return this;
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(Collection<? extends SortField<?>> fields) {
        this.withinGroupOrderBy.addAll(fields);
        return this;
    }

    @Override
    public final WindowPartitionByStep<T> over() {
        this.over = true;
        return this;
    }

    @Override
    public final WindowOrderByStep<T> partitionBy(Field<?> ... fields) {
        this.partitionBy.addAll((Collection<Field<?>>)Arrays.asList(fields));
        return this;
    }

    @Override
    public final WindowOrderByStep<T> partitionByOne() {
        this.partitionByOne = true;
        this.partitionBy.add(DSL.one());
        return this;
    }

    @Override
    public final WindowRowsStep<T> orderBy(Field<?> ... fields) {
        this.orderBy.addAll(fields);
        return this;
    }

    @Override
    public final WindowRowsStep<T> orderBy(SortField<?> ... fields) {
        this.orderBy.addAll(Arrays.asList(fields));
        return this;
    }

    @Override
    public final WindowRowsStep<T> orderBy(Collection<? extends SortField<?>> fields) {
        this.orderBy.addAll(fields);
        return this;
    }

    @Override
    public final WindowFinalStep<T> rowsUnboundedPreceding() {
        this.rowsStart = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowFinalStep<T> rowsPreceding(int number) {
        this.rowsStart = -number;
        return this;
    }

    @Override
    public final WindowFinalStep<T> rowsCurrentRow() {
        this.rowsStart = 0;
        return this;
    }

    @Override
    public final WindowFinalStep<T> rowsUnboundedFollowing() {
        this.rowsStart = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowFinalStep<T> rowsFollowing(int number) {
        this.rowsStart = number;
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenUnboundedPreceding() {
        this.rowsUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenPreceding(int number) {
        this.rowsPreceding(number);
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenCurrentRow() {
        this.rowsCurrentRow();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenUnboundedFollowing() {
        this.rowsUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenFollowing(int number) {
        this.rowsFollowing(number);
        return this;
    }

    @Override
    public final WindowFinalStep<T> andUnboundedPreceding() {
        this.rowsEnd = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowFinalStep<T> andPreceding(int number) {
        this.rowsEnd = -number;
        return this;
    }

    @Override
    public final WindowFinalStep<T> andCurrentRow() {
        this.rowsEnd = 0;
        return this;
    }

    @Override
    public final WindowFinalStep<T> andUnboundedFollowing() {
        this.rowsEnd = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowFinalStep<T> andFollowing(int number) {
        this.rowsEnd = number;
        return this;
    }
}

