/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.List;
import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Comparator;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.Utils;

class InCondition<T>
extends AbstractCondition {
    private static final long serialVersionUID = -1653924248576930761L;
    private static final int IN_LIMIT = 1000;
    private static final Clause[] CLAUSES_IN = new Clause[]{Clause.CONDITION, Clause.CONDITION_IN};
    private static final Clause[] CLAUSES_IN_NOT = new Clause[]{Clause.CONDITION, Clause.CONDITION_NOT_IN};
    private final Field<T> field;
    private final Field<?>[] values;
    private final Comparator comparator;

    InCondition(Field<T> field, Field<?>[] values, Comparator comparator) {
        this.field = field;
        this.values = values;
        this.comparator = comparator;
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.comparator == Comparator.IN ? CLAUSES_IN : CLAUSES_IN_NOT;
    }

    @Override
    public final void bind(BindContext context) {
        context.visit(this.field);
        Utils.visitAll(context, this.values);
    }

    @Override
    public final void toSQL(RenderContext context) {
        List<Field<?>> list = Arrays.asList(this.values);
        if (list.size() > 1000) {
            switch (context.configuration().dialect().family()) {
                case FIREBIRD: {
                    context.sql("(").formatIndentStart().formatNewLine();
                    for (int i = 0; i < list.size(); i += 1000) {
                        if (i > 0) {
                            if (this.comparator == Comparator.IN) {
                                context.formatSeparator().keyword("or").sql(" ");
                            } else {
                                context.formatSeparator().keyword("and").sql(" ");
                            }
                        }
                        this.toSQLSubValues(context, list.subList(i, Math.min(i + 1000, list.size())));
                    }
                    context.formatIndentEnd().formatNewLine().sql(")");
                    break;
                }
                default: {
                    this.toSQLSubValues(context, list);
                    break;
                }
            }
        } else {
            this.toSQLSubValues(context, list);
        }
    }

    private void toSQLSubValues(RenderContext context, List<Field<?>> subValues) {
        ((RenderContext)context.visit(this.field)).sql(" ").keyword(this.comparator.toSQL()).sql(" (");
        if (subValues.size() > 1) {
            context.formatIndentStart().formatNewLine();
        }
        String separator = "";
        for (Field<?> value : subValues) {
            context.sql(separator).formatNewLineAfterPrintMargin().visit(value);
            separator = ", ";
        }
        if (subValues.size() > 1) {
            context.formatIndentEnd().formatNewLine();
        }
        context.sql(")");
    }
}

