/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.BindContext;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractField;
import org.jooq.impl.ExpressionOperator;

class Neg<T>
extends AbstractField<T> {
    private static final long serialVersionUID = 7624782102883057433L;
    private final ExpressionOperator operator;
    private final Field<T> field;

    Neg(Field<T> field, ExpressionOperator operator) {
        super(operator.toSQL() + field.getName(), field.getDataType());
        this.operator = operator;
        this.field = field;
    }

    @Override
    public final void toSQL(RenderContext context) {
        SQLDialect family = context.configuration().dialect().family();
        if (this.operator == ExpressionOperator.BIT_NOT && Arrays.asList(SQLDialect.H2, SQLDialect.HSQLDB).contains((Object)family)) {
            ((RenderContext)context.sql("(0 -").visit(this.field)).sql(" - 1)");
        } else if (this.operator == ExpressionOperator.BIT_NOT && family == SQLDialect.FIREBIRD) {
            ((RenderContext)context.keyword("bin_not(").visit(this.field)).sql(")");
        } else {
            ((RenderContext)context.sql(this.operator.toSQL()).sql("(").visit(this.field)).sql(")");
        }
    }

    @Override
    public final void bind(BindContext context) {
        context.visit(this.field);
    }
}

