/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.List;
import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.QueryPart;
import org.jooq.RenderContext;
import org.jooq.Template;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.Utils;

class SQLTemplate
implements Template {
    private final String sql;

    SQLTemplate(String sql) {
        this.sql = sql;
    }

    @Override
    public final QueryPart transform(Object ... input) {
        return new SQLTemplateQueryPart(this.sql, input);
    }

    private static class SQLTemplateQueryPart
    extends AbstractQueryPart {
        private static final long serialVersionUID = -7514156096865122018L;
        private static final Clause[] CLAUSES = new Clause[]{Clause.TEMPLATE};
        private final String sql;
        private final List<QueryPart> substitutes;

        SQLTemplateQueryPart(String sql, Object ... input) {
            this.sql = sql;
            this.substitutes = Utils.queryParts(input);
        }

        @Override
        public final void toSQL(RenderContext context) {
            Utils.renderAndBind(context, null, this.sql, this.substitutes);
        }

        @Override
        public final void bind(BindContext context) {
            Utils.renderAndBind(null, context, this.sql, this.substitutes);
        }

        @Override
        public final Clause[] clauses(Context<?> ctx) {
            return CLAUSES;
        }
    }
}

