/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.GroupField;
import org.jooq.JoinType;
import org.jooq.Operator;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.SelectQuery;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.TablePartitionByStep;
import org.jooq.conf.ParamType;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractSelect;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultRenderContext;
import org.jooq.impl.Limit;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.SortFieldList;
import org.jooq.impl.TableList;
import org.jooq.impl.TrueCondition;
import org.jooq.impl.Utils;
import org.jooq.tools.StringUtils;

class SelectQueryImpl<R extends Record>
extends AbstractSelect<R>
implements SelectQuery<R> {
    private static final long serialVersionUID = 1646393178384872967L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.SELECT};
    private final SelectFieldList select;
    private String hint;
    private String option;
    private boolean distinct;
    private boolean forUpdate;
    private final QueryPartList<Field<?>> forUpdateOf;
    private final TableList forUpdateOfTables;
    private ForUpdateMode forUpdateMode;
    private int forUpdateWait;
    private boolean forShare;
    private final TableList from;
    private final ConditionProviderImpl condition;
    private final ConditionProviderImpl connectBy;
    private boolean connectByNoCycle;
    private final ConditionProviderImpl connectByStartWith;
    private boolean grouping;
    private final QueryPartList<GroupField> groupBy;
    private final ConditionProviderImpl having;
    private final SortFieldList orderBy;
    private boolean orderBySiblings;
    private final Limit limit;

    SelectQueryImpl(Configuration configuration) {
        this(configuration, null);
    }

    SelectQueryImpl(Configuration configuration, boolean distinct) {
        this(configuration, null, distinct);
    }

    SelectQueryImpl(Configuration configuration, TableLike<? extends R> from) {
        this(configuration, from, false);
    }

    SelectQueryImpl(Configuration configuration, TableLike<? extends R> from, boolean distinct) {
        super(configuration);
        this.distinct = distinct;
        this.select = new SelectFieldList();
        this.from = new TableList();
        this.condition = new ConditionProviderImpl();
        this.connectBy = new ConditionProviderImpl();
        this.connectByStartWith = new ConditionProviderImpl();
        this.groupBy = new QueryPartList();
        this.having = new ConditionProviderImpl();
        this.orderBy = new SortFieldList();
        this.limit = new Limit();
        if (from != null) {
            this.from.add(from.asTable());
        }
        this.forUpdateOf = new QueryPartList();
        this.forUpdateOfTables = new TableList();
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final void bind(BindContext context) {
        ((BindContext)((BindContext)((BindContext)((BindContext)((BindContext)((BindContext)((BindContext)((BindContext)((BindContext)((BindContext)((BindContext)context.declareFields(true)).visit(this.getSelect0())).declareFields(false)).declareTables(true)).visit(this.getFrom())).declareTables(false)).visit(this.getWhere())).visit(this.getConnectByStartWith())).visit(this.getConnectBy())).visit(this.getGroupBy())).visit(this.getHaving())).visit(this.getOrderBy());
        if (this.getLimit().isApplicable()) {
            context.visit(this.getLimit());
        }
        ((BindContext)context.visit(this.forUpdateOf)).visit(this.forUpdateOfTables);
    }

    @Override
    public final void toSQL(RenderContext context) {
        Boolean wrapDerivedTables = (Boolean)context.data("org.jooq.configuration.wrap-derived-tables-in-parentheses");
        if (Boolean.TRUE.equals(wrapDerivedTables)) {
            context.sql("(").data("org.jooq.configuration.wrap-derived-tables-in-parentheses", null);
        }
        if (this.getLimit().isApplicable()) {
            switch (context.configuration().dialect()) {
                default: 
            }
            this.toSQLReferenceLimitDefault(context);
        } else {
            this.toSQLReference0(context);
        }
        if (this.forUpdate && !Arrays.asList(SQLDialect.CUBRID).contains((Object)context.configuration().dialect().family())) {
            context.formatSeparator().keyword("for update");
            if (!this.forUpdateOf.isEmpty()) {
                context.sql(" ").keyword("of").sql(" ");
                Utils.fieldNames(context, this.forUpdateOf);
            } else if (!this.forUpdateOfTables.isEmpty()) {
                context.sql(" ").keyword("of").sql(" ");
                switch (context.configuration().dialect().family()) {
                    case DERBY: {
                        this.forUpdateOfTables.toSQLFieldNames(context);
                        break;
                    }
                    default: {
                        Utils.tableNames(context, this.forUpdateOfTables);
                    }
                }
            }
            if (this.forUpdateMode != null) {
                context.sql(" ");
                context.keyword(this.forUpdateMode.toSQL());
                if (this.forUpdateMode == ForUpdateMode.WAIT) {
                    context.sql(" ");
                    context.sql(this.forUpdateWait);
                }
            }
        } else if (this.forShare) {
            switch (context.configuration().dialect()) {
                case MARIADB: 
                case MYSQL: {
                    context.formatSeparator().keyword("lock in share mode");
                    break;
                }
                default: {
                    context.formatSeparator().keyword("for share");
                }
            }
        }
        if (!StringUtils.isBlank(this.option)) {
            context.formatSeparator().sql(this.option);
        }
        if (Boolean.TRUE.equals(wrapDerivedTables)) {
            context.sql(")").data("org.jooq.configuration.wrap-derived-tables-in-parentheses", true);
        }
    }

    private void toSQLReferenceLimitDefault(RenderContext context) {
        this.toSQLReference0(context);
        context.visit(this.getLimit());
    }

    private final void toSQLReference0(RenderContext context) {
        this.toSQLReference0(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void toSQLReference0(RenderContext context, QueryPart limitOffsetRownumber) {
        SQLDialect dialect = context.configuration().dialect();
        ((RenderContext)context.start(Clause.SELECT_SELECT)).keyword("select").sql(" ");
        if (!StringUtils.isBlank(this.hint)) {
            context.sql(this.hint).sql(" ");
        }
        if (this.distinct) {
            context.keyword("distinct").sql(" ");
        }
        context.declareFields(true);
        if (context.subquery() && dialect == SQLDialect.H2 && context.data("org.jooq.configuration.row-value-expression-subquery") != null) {
            Object data = context.data("org.jooq.configuration.row-value-expression-subquery");
            try {
                context.data("org.jooq.configuration.row-value-expression-subquery", null);
                ((RenderContext)context.sql("(").visit(this.getSelect1())).sql(")");
            }
            finally {
                context.data("org.jooq.configuration.row-value-expression-subquery", data);
            }
        } else {
            context.visit(this.getSelect1());
        }
        if (limitOffsetRownumber != null) {
            ParamType paramType = context.paramType();
            ((RenderContext)context.paramType(ParamType.INLINED).sql(",").formatIndentStart().formatSeparator().visit(limitOffsetRownumber)).formatIndentEnd().paramType(paramType);
        }
        ((RenderContext)context.declareFields(false)).end(Clause.SELECT_SELECT);
        ((RenderContext)context.start(Clause.SELECT_FROM)).declareTables(true);
        DefaultConfiguration c = new DefaultConfiguration(context.configuration().dialect());
        String renderedFrom = new DefaultRenderContext(c).render(this.getFrom());
        if (!renderedFrom.isEmpty()) {
            context.formatSeparator().keyword("from").sql(" ").visit(this.getFrom());
            if (this.grouping && this.getGroupBy().isEmpty() && Arrays.asList(new Object[0]).contains((Object)dialect)) {
                context.sql(", (select 1 as x) as empty_grouping_dummy_table");
            }
        }
        ((RenderContext)context.declareTables(false)).end(Clause.SELECT_FROM);
        context.start(Clause.SELECT_WHERE);
        if (!(this.getWhere().getWhere() instanceof TrueCondition)) {
            context.formatSeparator().keyword("where").sql(" ").visit(this.getWhere());
        }
        context.end(Clause.SELECT_WHERE);
        context.start(Clause.SELECT_START_WITH);
        if (!(this.getConnectByStartWith().getWhere() instanceof TrueCondition)) {
            context.formatSeparator().keyword("start with").sql(" ").visit(this.getConnectByStartWith());
        }
        context.end(Clause.SELECT_START_WITH);
        context.start(Clause.SELECT_CONNECT_BY);
        if (!(this.getConnectBy().getWhere() instanceof TrueCondition)) {
            context.formatSeparator().keyword("connect by");
            if (this.connectByNoCycle) {
                context.sql(" ").keyword("nocycle");
            }
            context.sql(" ").visit(this.getConnectBy());
        }
        context.end(Clause.SELECT_CONNECT_BY);
        context.start(Clause.SELECT_GROUP_BY);
        if (this.grouping) {
            context.formatSeparator().keyword("group by").sql(" ");
            if (this.getGroupBy().isEmpty()) {
                if (Arrays.asList(new Object[0]).contains((Object)dialect)) {
                    context.sql("empty_grouping_dummy_table.x");
                } else if (Arrays.asList(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE).contains((Object)dialect)) {
                    context.sql("1");
                } else {
                    context.sql("()");
                }
            } else {
                context.visit(this.getGroupBy());
            }
        }
        context.end(Clause.SELECT_GROUP_BY);
        context.start(Clause.SELECT_HAVING);
        if (!(this.getHaving().getWhere() instanceof TrueCondition)) {
            context.formatSeparator().keyword("having").sql(" ").visit(this.getHaving());
        }
        context.end(Clause.SELECT_HAVING);
        context.start(Clause.SELECT_ORDER_BY);
        if (!this.getOrderBy().isEmpty()) {
            context.formatSeparator().keyword("order").sql(this.orderBySiblings ? " " : "").keyword(this.orderBySiblings ? "siblings" : "").sql(" ").keyword("by").sql(" ").visit(this.getOrderBy());
        } else if (this.getLimit().isApplicable() && Arrays.asList(new Object[0]).contains((Object)dialect)) {
            context.formatSeparator().keyword("order by").sql(" 1");
        }
        context.end(Clause.SELECT_ORDER_BY);
    }

    @Override
    public final void addSelect(Collection<? extends Field<?>> fields) {
        this.getSelect0().addAll(fields);
    }

    @Override
    public final void addSelect(Field<?> ... fields) {
        this.addSelect(Arrays.asList(fields));
    }

    @Override
    public final void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public final void addLimit(int numberOfRows) {
        this.addLimit(0, numberOfRows);
    }

    @Override
    public final void addLimit(Param<Integer> numberOfRows) {
        this.addLimit(0, numberOfRows);
    }

    @Override
    public final void addLimit(int offset, int numberOfRows) {
        this.limit.setOffset(offset);
        this.limit.setNumberOfRows(numberOfRows);
    }

    @Override
    public final void addLimit(int offset, Param<Integer> numberOfRows) {
        this.limit.setOffset(offset);
        this.limit.setNumberOfRows(numberOfRows);
    }

    @Override
    public final void addLimit(Param<Integer> offset, int numberOfRows) {
        this.limit.setOffset(offset);
        this.limit.setNumberOfRows(numberOfRows);
    }

    @Override
    public final void addLimit(Param<Integer> offset, Param<Integer> numberOfRows) {
        this.limit.setOffset(offset);
        this.limit.setNumberOfRows(numberOfRows);
    }

    @Override
    public final void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
        this.forShare = false;
    }

    @Override
    public final void setForUpdateOf(Field<?> ... fields) {
        this.setForUpdateOf(Arrays.asList(fields));
    }

    @Override
    public final void setForUpdateOf(Collection<? extends Field<?>> fields) {
        this.setForUpdate(true);
        this.forUpdateOf.clear();
        this.forUpdateOfTables.clear();
        this.forUpdateOf.addAll((Collection<Field<?>>)fields);
    }

    @Override
    public final void setForUpdateOf(Table<?> ... tables) {
        this.setForUpdate(true);
        this.forUpdateOf.clear();
        this.forUpdateOfTables.clear();
        this.forUpdateOfTables.addAll(Arrays.asList(tables));
    }

    @Override
    public final void setForUpdateNoWait() {
        this.setForUpdate(true);
        this.forUpdateMode = ForUpdateMode.NOWAIT;
        this.forUpdateWait = 0;
    }

    @Override
    public final void setForShare(boolean forShare) {
        this.forUpdate = false;
        this.forShare = forShare;
        this.forUpdateOf.clear();
        this.forUpdateOfTables.clear();
        this.forUpdateMode = null;
        this.forUpdateWait = 0;
    }

    @Override
    public final List<Field<?>> getSelect() {
        return this.getSelect1();
    }

    final SelectFieldList getSelect0() {
        return this.select;
    }

    final SelectFieldList getSelect1() {
        if (this.getSelect0().isEmpty()) {
            SelectFieldList result = new SelectFieldList();
            if (this.knownTableSource()) {
                for (TableLike table : this.getFrom()) {
                    for (Field<?> field : table.asTable().fields()) {
                        result.add(field);
                    }
                }
            }
            if (this.getFrom().isEmpty()) {
                result.add(DSL.one());
            }
            return result;
        }
        return this.getSelect0();
    }

    private final boolean knownTableSource() {
        for (Table table : this.getFrom()) {
            if (this.knownTable(table)) continue;
            return false;
        }
        return true;
    }

    private final boolean knownTable(Table<?> table) {
        return table.fieldsRow().size() > 0;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        if (this.getFrom().size() == 1 && this.getSelect0().isEmpty()) {
            return ((Table)this.getFrom().get(0)).asTable().getRecordType();
        }
        return RecordImpl.class;
    }

    final TableList getFrom() {
        return this.from;
    }

    final void setGrouping() {
        this.grouping = true;
    }

    final QueryPartList<GroupField> getGroupBy() {
        return this.groupBy;
    }

    final Limit getLimit() {
        return this.limit;
    }

    final ConditionProviderImpl getWhere() {
        return this.condition;
    }

    final ConditionProviderImpl getConnectBy() {
        return this.connectBy;
    }

    final ConditionProviderImpl getConnectByStartWith() {
        return this.connectByStartWith;
    }

    final ConditionProviderImpl getHaving() {
        return this.having;
    }

    final SortFieldList getOrderBy() {
        return this.orderBy;
    }

    final SortFieldList getNonEmptyOrderBy() {
        if (this.getOrderBy().isEmpty()) {
            SortFieldList result = new SortFieldList();
            result.add(this.getSelect().get(0).asc());
            return result;
        }
        return this.getOrderBy();
    }

    @Override
    public final void addOrderBy(Collection<? extends SortField<?>> fields) {
        this.getOrderBy().addAll(fields);
    }

    @Override
    public final void addOrderBy(Field<?> ... fields) {
        this.getOrderBy().addAll(fields);
    }

    @Override
    public final void addOrderBy(SortField<?> ... fields) {
        this.addOrderBy(Arrays.asList(fields));
    }

    @Override
    public final void addOrderBy(int ... fieldIndexes) {
        Field[] fields = new Field[fieldIndexes.length];
        for (int i = 0; i < fieldIndexes.length; ++i) {
            fields[i] = DSL.inline(fieldIndexes[i]);
        }
        this.addOrderBy(fields);
    }

    @Override
    public final void setOrderBySiblings(boolean orderBySiblings) {
        this.orderBySiblings = orderBySiblings;
    }

    @Override
    public final void addConditions(Condition ... conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Collection<? extends Condition> conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Operator operator, Condition ... conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addConditions(Operator operator, Collection<? extends Condition> conditions) {
        this.condition.addConditions(operator, conditions);
    }

    final void setConnectByNoCycle(boolean connectByNoCycle) {
        this.connectByNoCycle = connectByNoCycle;
    }

    final void setStartWith(Condition condition) {
        this.connectByStartWith.addConditions(condition);
    }

    final void setHint(String hint) {
        this.hint = hint;
    }

    final void setOption(String option) {
        this.option = option;
    }

    @Override
    final boolean isForUpdate() {
        return this.forUpdate;
    }

    @Override
    public final void addFrom(Collection<? extends TableLike<?>> f) {
        for (TableLike<?> provider : f) {
            this.getFrom().add(provider.asTable());
        }
    }

    @Override
    public final void addFrom(TableLike<?> ... f) {
        this.addFrom(Arrays.asList(f));
    }

    @Override
    public final void addConnectBy(Condition c) {
        this.getConnectBy().addConditions(c);
    }

    @Override
    public final void addConnectByNoCycle(Condition c) {
        this.getConnectBy().addConditions(c);
        this.setConnectByNoCycle(true);
    }

    @Override
    public final void setConnectByStartWith(Condition c) {
        this.setStartWith(c);
    }

    @Override
    public final void addGroupBy(Collection<? extends GroupField> fields) {
        this.setGrouping();
        this.getGroupBy().addAll((Collection<GroupField>)fields);
    }

    @Override
    public final void addGroupBy(GroupField ... fields) {
        this.addGroupBy(Arrays.asList(fields));
    }

    @Override
    public final void addHaving(Condition ... conditions) {
        this.addHaving(Arrays.asList(conditions));
    }

    @Override
    public final void addHaving(Collection<? extends Condition> conditions) {
        this.getHaving().addConditions(conditions);
    }

    @Override
    public final void addHaving(Operator operator, Condition ... conditions) {
        this.getHaving().addConditions(operator, conditions);
    }

    @Override
    public final void addHaving(Operator operator, Collection<? extends Condition> conditions) {
        this.getHaving().addConditions(operator, conditions);
    }

    @Override
    public final void addJoin(TableLike<?> table, Condition ... conditions) {
        this.addJoin(table, JoinType.JOIN, conditions);
    }

    @Override
    public final void addJoin(TableLike<?> table, JoinType type, Condition ... conditions) {
        this.addJoin0(table, type, conditions, null);
    }

    private final void addJoin0(TableLike<?> table, JoinType type, Condition[] conditions, Field<?>[] partitionBy) {
        int index = this.getFrom().size() - 1;
        TableOnConditionStep joined = null;
        switch (type) {
            case JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table).on(conditions);
                break;
            }
            case LEFT_OUTER_JOIN: {
                TablePartitionByStep p;
                TablePartitionByStep o = p = ((Table)this.getFrom().get(index)).leftOuterJoin(table);
                joined = o.on(conditions);
                break;
            }
            case RIGHT_OUTER_JOIN: {
                TablePartitionByStep p;
                TablePartitionByStep o = p = ((Table)this.getFrom().get(index)).rightOuterJoin(table);
                joined = o.on(conditions);
                break;
            }
            case FULL_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).fullOuterJoin(table).on(conditions);
                break;
            }
            case CROSS_JOIN: {
                joined = ((Table)this.getFrom().get(index)).crossJoin(table);
                break;
            }
            case NATURAL_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalJoin(table);
                break;
            }
            case NATURAL_LEFT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalLeftOuterJoin(table);
                break;
            }
            case NATURAL_RIGHT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalRightOuterJoin(table);
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addJoinOnKey(TableLike<?> table, JoinType type) throws DataAccessException {
        int index = this.getFrom().size() - 1;
        TableOnConditionStep joined = null;
        switch (type) {
            case JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table).onKey();
                break;
            }
            case LEFT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).leftOuterJoin(table).onKey();
                break;
            }
            case RIGHT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).rightOuterJoin(table).onKey();
                break;
            }
            case FULL_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).fullOuterJoin(table).onKey();
                break;
            }
            case CROSS_JOIN: {
                joined = ((Table)this.getFrom().get(index)).crossJoin(table);
                break;
            }
            case NATURAL_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalJoin(table);
                break;
            }
            case NATURAL_LEFT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalLeftOuterJoin(table);
                break;
            }
            case NATURAL_RIGHT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalRightOuterJoin(table);
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addJoinOnKey(TableLike<?> table, JoinType type, TableField<?, ?> ... keyFields) throws DataAccessException {
        int index = this.getFrom().size() - 1;
        TableOnConditionStep joined = null;
        switch (type) {
            case JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table).onKey(keyFields);
                break;
            }
            case LEFT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).leftOuterJoin(table).onKey(keyFields);
                break;
            }
            case RIGHT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).rightOuterJoin(table).onKey(keyFields);
                break;
            }
            case FULL_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).fullOuterJoin(table).onKey(keyFields);
                break;
            }
            case CROSS_JOIN: {
                joined = ((Table)this.getFrom().get(index)).crossJoin(table);
                break;
            }
            case NATURAL_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalJoin(table);
                break;
            }
            case NATURAL_LEFT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalLeftOuterJoin(table);
                break;
            }
            case NATURAL_RIGHT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalRightOuterJoin(table);
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addJoinOnKey(TableLike<?> table, JoinType type, ForeignKey<?, ?> key) {
        int index = this.getFrom().size() - 1;
        TableOnConditionStep joined = null;
        switch (type) {
            case JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table).onKey(key);
                break;
            }
            case LEFT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).leftOuterJoin(table).onKey(key);
                break;
            }
            case RIGHT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).rightOuterJoin(table).onKey(key);
                break;
            }
            case FULL_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).fullOuterJoin(table).onKey(key);
                break;
            }
            case CROSS_JOIN: {
                joined = ((Table)this.getFrom().get(index)).crossJoin(table);
                break;
            }
            case NATURAL_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalJoin(table);
                break;
            }
            case NATURAL_LEFT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalLeftOuterJoin(table);
                break;
            }
            case NATURAL_RIGHT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalRightOuterJoin(table);
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addJoinUsing(TableLike<?> table, Collection<? extends Field<?>> fields) {
        this.addJoinUsing(table, JoinType.JOIN, fields);
    }

    @Override
    public final void addJoinUsing(TableLike<?> table, JoinType type, Collection<? extends Field<?>> fields) {
        int index = this.getFrom().size() - 1;
        Table<Record> joined = null;
        switch (type) {
            case JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table).using(fields);
                break;
            }
            case LEFT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).leftOuterJoin(table).using(fields);
                break;
            }
            case RIGHT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).rightOuterJoin(table).using(fields);
                break;
            }
            case FULL_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).fullOuterJoin(table).using(fields);
                break;
            }
            case CROSS_JOIN: {
                joined = ((Table)this.getFrom().get(index)).crossJoin(table);
                break;
            }
            case NATURAL_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalJoin(table);
                break;
            }
            case NATURAL_LEFT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalLeftOuterJoin(table);
                break;
            }
            case NATURAL_RIGHT_OUTER_JOIN: {
                joined = ((Table)this.getFrom().get(index)).naturalRightOuterJoin(table);
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addHint(String h) {
        this.setHint(h);
    }

    @Override
    public final void addOption(String o) {
        this.setOption(o);
    }

    private static enum ForUpdateMode {
        WAIT("wait"),
        NOWAIT("nowait"),
        SKIP_LOCKED("skip locked");

        private final String sql;

        private ForUpdateMode(String sql) {
            this.sql = sql;
        }

        public final String toSQL() {
            return this.sql;
        }
    }
}

