/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.tools;

import java.util.logging.Level;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteType;
import org.jooq.conf.ParamType;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public class LoggerListener
extends DefaultExecuteListener {
    private static final long serialVersionUID = 7399239846062763212L;
    private static final JooqLogger log = JooqLogger.getLogger(LoggerListener.class);

    @Override
    public void renderEnd(ExecuteContext ctx) {
        if (log.isDebugEnabled()) {
            String[] batchSQL = ctx.batchSQL();
            if (ctx.query() != null) {
                log.debug((Object)"Executing query", ctx.sql());
                String inlined = ctx.query().getSQL(ParamType.INLINED);
                if (!ctx.sql().equals(inlined)) {
                    log.debug((Object)"-> with bind values", inlined);
                }
            } else if (!StringUtils.isBlank(ctx.sql())) {
                if (ctx.type() == ExecuteType.BATCH) {
                    log.debug((Object)"Executing batch query", ctx.sql());
                } else {
                    log.debug((Object)"Executing query", ctx.sql());
                }
            } else if (batchSQL.length > 0 && batchSQL[batchSQL.length - 1] != null) {
                for (String sql : batchSQL) {
                    log.debug((Object)"Executing batch query", sql);
                }
            }
        }
    }

    @Override
    public void recordEnd(ExecuteContext ctx) {
        if (log.isTraceEnabled() && ctx.record() != null) {
            this.logMultiline("Record fetched", ctx.record().toString(), Level.FINER);
        }
    }

    @Override
    public void resultEnd(ExecuteContext ctx) {
        if (log.isDebugEnabled() && ctx.result() != null) {
            this.logMultiline("Fetched result", ctx.result().format(5), Level.FINE);
        }
    }

    @Override
    public void executeEnd(ExecuteContext ctx) {
        if (log.isDebugEnabled() && ctx.rows() >= 0) {
            log.debug((Object)"Affected row(s)", ctx.rows());
        }
    }

    private void logMultiline(String comment, String message, Level level) {
        for (String line : message.split("\n")) {
            if (level == Level.FINE) {
                log.debug((Object)comment, line);
            } else {
                log.trace((Object)comment, line);
            }
            comment = "";
        }
    }
}

