/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter.heatmapcrop;

import adams.core.option.AbstractOptionHandler;
import adams.data.heatmap.Heatmap;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import java.awt.Point;

public abstract class AbstractHeatmapCrop
extends AbstractOptionHandler {
    public static final String CROP_LEFT = "Crop.Left";
    public static final String CROP_TOP = "Crop.Top";
    public static final String CROP_RIGHT = "Crop.Right";
    public static final String CROP_BOTTOM = "Crop.Bottom";
    protected Point m_TopLeft;
    protected Point m_BottomRight;

    protected void check(Heatmap map) {
        if (map == null) {
            throw new IllegalStateException("No heatmap provided!");
        }
    }

    protected void preCrop(Heatmap map) {
        this.m_TopLeft = new Point(0, 0);
        this.m_BottomRight = new Point(map.getWidth(), map.getHeight());
        if (this.isLoggingEnabled()) {
            this.getLogger().info("mapWidth=" + map.getWidth() + ", mapHeight=" + map.getHeight());
        }
    }

    protected abstract Heatmap doCrop(Heatmap var1);

    protected void postCrop(Heatmap map) {
        Report report = map.getReport();
        report.addField((AbstractField)new Field(CROP_LEFT, DataType.NUMERIC));
        report.addField((AbstractField)new Field(CROP_TOP, DataType.NUMERIC));
        report.addField((AbstractField)new Field(CROP_RIGHT, DataType.NUMERIC));
        report.addField((AbstractField)new Field(CROP_BOTTOM, DataType.NUMERIC));
        report.setNumericValue(CROP_LEFT, this.m_TopLeft.getX());
        report.setNumericValue(CROP_TOP, this.m_TopLeft.getY());
        report.setNumericValue(CROP_RIGHT, this.m_BottomRight.getX());
        report.setNumericValue(CROP_BOTTOM, this.m_BottomRight.getY());
    }

    public Heatmap crop(Heatmap map) {
        this.check(map);
        this.preCrop(map);
        Heatmap result = this.doCrop(map);
        this.postCrop(result);
        return result;
    }
}

