/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.heatmap.Heatmap;
import adams.data.io.input.AbstractHeatmapReader;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;

public class SimpleHeatmapReader
extends AbstractHeatmapReader {
    private static final long serialVersionUID = -2903357410192470809L;

    public String globalInfo() {
        return "Reads heatmaps in the internal heatmap CSV format.";
    }

    public String getFormatDescription() {
        return "Simple heatmap CSV format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"hm", "hm.gz"};
    }

    protected void determineDimensions(List<String> content, Report meta) {
        int height = 0;
        int width = 0;
        for (String line : content) {
            String[] parts;
            if (line.trim().length() == 0 || (parts = line.split(",")).length != 3) continue;
            int row = Integer.parseInt(parts[0]);
            int col = Integer.parseInt(parts[1]);
            height = Math.max(height, row + 1);
            width = Math.max(width, col + 1);
        }
        meta.setValue((AbstractField)new Field("Height", DataType.NUMERIC), (Object)height);
        meta.setValue((AbstractField)new Field("Width", DataType.NUMERIC), (Object)width);
    }

    protected boolean read(BufferedReader reader) {
        boolean result = true;
        try {
            String line;
            ArrayList<String> content = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                content.add(line);
            }
            ArrayList report = new ArrayList();
            while (content.size() > 0 && ((String)content.get(0)).startsWith("# ")) {
                report.add(content.get(0));
                content.remove(0);
            }
            Report meta = null;
            if (report.size() > 0) {
                meta = Report.parseProperties((Properties)Properties.fromComment((String)Utils.flatten(report, (String)"\n")));
            }
            if (meta == null) {
                meta = new Report();
            }
            if (!meta.hasValue("Height") || !meta.hasValue("Width")) {
                this.determineDimensions(content, meta);
            }
            Heatmap map = new Heatmap(meta.getDoubleValue("Height").intValue(), meta.getDoubleValue("Width").intValue());
            if (meta.hasValue("ID")) {
                map.setID(meta.getStringValue("ID"));
            }
            map.setReport(meta);
            this.m_ReadData.add(map);
            if (content.size() > 0) {
                content.remove(0);
            }
            while (content.size() > 0 && result) {
                String[] parts;
                line = ((String)content.get(0)).trim();
                content.remove(0);
                if (line.length() == 0 || (parts = line.split(",")).length != 3) continue;
                map.set(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Double.parseDouble(parts[2]));
            }
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed to read heatmap data!", e);
        }
        return result;
    }

    protected boolean read(String filename) {
        boolean result;
        filename = new PlaceholderFile(filename).getAbsolutePath();
        try {
            BufferedReader reader = filename.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename)))) : new BufferedReader(new FileReader(filename));
            result = this.read(reader);
            reader.close();
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed to read spectral data from '" + filename + "'!", e);
        }
        return result;
    }

    protected void readData() {
        this.read(this.m_Input.getAbsolutePath());
    }
}

