/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.data.heatmap.Heatmap;
import adams.data.io.input.AbstractHeatmapReader;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.ByContentType;
import java.io.File;

public class SpreadSheetHeatmapReader
extends AbstractHeatmapReader {
    private static final long serialVersionUID = -2903357410192470809L;
    protected SpreadSheetReader m_Reader;

    public String globalInfo() {
        return "Turns spreadsheets into heatmaps.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new CsvSpreadSheetReader());
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for reading the spreadsheet data.";
    }

    public String getFormatDescription() {
        return "Heatmap in spreadsheet-format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"*"};
    }

    protected void readData() {
        SpreadSheet sheet = this.m_Reader.read((File)this.m_Input);
        ByContentType finder = new ByContentType();
        finder.setContentTypes(new Cell.ContentType[]{Cell.ContentType.LONG, Cell.ContentType.DOUBLE});
        int[] numeric = finder.findColumns(sheet);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("columns: " + Utils.arrayToString((Object)numeric));
        }
        if (numeric.length == 0) {
            this.getLogger().severe("No numeric columns found!");
            return;
        }
        Heatmap map = new Heatmap(sheet.getRowCount(), numeric.length);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("map: rows=" + map.getHeight() + ", cols=" + map.getWidth());
        }
        for (int n = 0; n < sheet.getRowCount(); ++n) {
            for (int i = 0; i < numeric.length; ++i) {
                Cell cell = sheet.getCell(n, numeric[i]);
                double value = 0.0;
                if (cell != null && cell.isNumeric()) {
                    value = cell.toDouble();
                }
                map.set(n, i, value);
            }
        }
        this.m_ReadData.add(map);
    }
}

