/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.CompressionSupporter;
import adams.data.heatmap.Heatmap;
import adams.data.heatmap.HeatmapValue;
import adams.data.io.input.SimpleHeatmapReader;
import adams.data.io.output.AbstractHeatmapWriter;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;

public class SimpleHeatmapWriter
extends AbstractHeatmapWriter
implements CompressionSupporter {
    private static final long serialVersionUID = 5290679698357490093L;
    protected int m_NumDecimals;
    protected boolean m_OutputMetaData;
    protected boolean m_UseCompression;

    public String globalInfo() {
        return "Writer that stores heatmaps in a simple CSV-like format.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)6, (Number)0, (Number)16);
        this.m_OptionManager.add("output-meta-data", "outputMetaData", (Object)true);
        this.m_OptionManager.add("use-compression", "useCompression", (Object)false);
    }

    public String getFormatDescription() {
        return new SimpleHeatmapReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new SimpleHeatmapReader().getFormatExtensions();
    }

    public void setNumDecimals(int value) {
        this.m_NumDecimals = value;
        this.reset();
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals to output after the decimal point (at most).";
    }

    public void setOutputMetaData(boolean value) {
        this.m_OutputMetaData = value;
        this.reset();
    }

    public boolean getOutputMetaData() {
        return this.m_OutputMetaData;
    }

    public String outputMetaDataTipText() {
        return "If set to true, the meta data gets stored in the file as well (as comment).";
    }

    public void setUseCompression(boolean value) {
        this.m_UseCompression = value;
        this.reset();
    }

    public boolean getUseCompression() {
        return this.m_UseCompression;
    }

    public String useCompressionTipText() {
        return "If enabled, the heatmap is compressed using GZIP and appending '.gz' to the filename.";
    }

    protected void initialize() {
        super.initialize();
        this.m_OutputIsFile = true;
    }

    protected boolean write(List<Heatmap> data, BufferedWriter writer, boolean report) {
        boolean result = true;
        try {
            Heatmap map = data.get(0);
            if (map.hasReport() && report) {
                Object[] lines = map.getReport().toProperties().toComment().split("\n");
                Arrays.sort(lines);
                writer.write(Utils.flatten((Object[])lines, (String)"\n"));
                writer.write("\n");
            }
            writer.write("Row,Column,Intensity");
            writer.write("\n");
            Iterator<HeatmapValue> iterator = map.iterator();
            while (iterator.hasNext()) {
                HeatmapValue value = iterator.next();
                writer.write("" + value.getY());
                writer.write(",");
                writer.write("" + value.getX());
                writer.write(",");
                writer.write(Utils.doubleToString((double)value.getValue(), (int)this.m_NumDecimals));
                writer.write("\n");
            }
            writer.flush();
            result = true;
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed to write heatmap to writer!", e);
        }
        return result;
    }

    protected boolean write(List<Heatmap> data, String filename, boolean report) {
        boolean result;
        filename = new PlaceholderFile(filename).getAbsolutePath();
        try {
            BufferedWriter writer = filename.endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(filename)))) : new BufferedWriter(new FileWriter(filename));
            result = this.write(data, writer, report);
            writer.close();
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed to write heatmap to '" + filename + "'!", e);
        }
        return result;
    }

    protected boolean writeData(List<Heatmap> data) {
        boolean result = this.write(data, this.m_Output.getAbsolutePath(), this.m_OutputMetaData);
        if (!result) {
            this.getLogger().severe("Error writing data to '" + this.m_Output.getAbsolutePath() + "'!");
        }
        return result;
    }
}

