/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.data.io.input.AbstractCsvArchive;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.twitter.TwitterField;
import java.util.HashMap;

public class TwitterExportArchive
extends AbstractCsvArchive {
    private static final long serialVersionUID = -3432288686771377759L;

    public String globalInfo() {
        return "Replays tweets stored in a CSV file generate by a Twitter export.\nExtracts hashtags ('#...') and usermentions ('@...') automatically.";
    }

    @Override
    public String archiveTipText() {
        return "The Twitter export CSV file to load the tweets from.";
    }

    @Override
    protected HashMap<TwitterField, Integer> configureColumns(SpreadSheet chunk) {
        HashMap<TwitterField, Integer> result = new HashMap<TwitterField, Integer>();
        HeaderRow row = this.m_Chunk.getHeaderRow();
        block24: for (int i = 0; i < this.m_Chunk.getColumnCount(); ++i) {
            switch (row.getCell(i).getContent()) {
                case "tweet_id": {
                    result.put(TwitterField.ID, i);
                    continue block24;
                }
                case "in_reply_to_status_id": {
                    result.put(TwitterField.IN_REPLY_TO_STATUS_ID, i);
                    continue block24;
                }
                case "in_reply_to_user_id": {
                    result.put(TwitterField.IN_REPLY_TO_USER_ID, i);
                    continue block24;
                }
                case "timestamp": {
                    result.put(TwitterField.CREATED, i);
                    continue block24;
                }
                case "source": {
                    result.put(TwitterField.SOURCE, i);
                    continue block24;
                }
                case "text": {
                    result.put(TwitterField.TEXT, i);
                    continue block24;
                }
                case "retweeted_status_id": {
                    result.put(TwitterField.RETWEETED_STATUS_ID, i);
                    continue block24;
                }
                case "retweeted_status_user_id": {
                    result.put(TwitterField.RETWEETED_STATUS_USER_ID, i);
                    continue block24;
                }
                case "retweeted_status_timestamp": {
                    result.put(TwitterField.RETWEETED_STATUS_CREATED, i);
                    continue block24;
                }
                case "expanded_urls": {
                    result.put(TwitterField.EXPANDED_URLS, i);
                }
            }
        }
        return result;
    }
}

