/*
 * Decompiled with CFR 0.152.
 */
package adams.data.twitter;

import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.Utils;
import adams.core.net.TwitterHelper;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.data.twitter.TwitterField;
import java.util.Hashtable;
import twitter4j.Status;

public abstract class AbstractTwitterStatusConverter<T>
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = 5446751589621732002L;
    protected TwitterField[] m_Fields;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "fields", (Object)new TwitterField[]{TwitterField.TEXT});
    }

    public void setFields(TwitterField[] value) {
        this.m_Fields = value;
        this.reset();
    }

    public TwitterField[] getFields() {
        return this.m_Fields;
    }

    public String fieldsTipText() {
        return "The fields to use for generating the output.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"fields", (Object)Utils.flatten((Object[])this.m_Fields, (String)", "), (String)"fields: ");
    }

    public abstract Class generates();

    protected void check(Status status) {
        if (status == null) {
            throw new IllegalArgumentException("No status update provided!");
        }
    }

    protected abstract T doConvert(Hashtable<TwitterField, Object> var1);

    public T convert(Status status) {
        this.check(status);
        return this.doConvert(TwitterHelper.statusToHashtable(status));
    }
}

